/*
 * Decompiled with CFR 0.152.
 */
package io.github.dft.amazon;

import com.amazonaws.DefaultRequest;
import com.amazonaws.http.HttpMethodName;
import io.github.dft.amazon.AmazonSellingPartnerSdk;
import io.github.dft.amazon.model.AmazonCredentials;
import io.github.dft.amazon.model.handler.JsonBodyHandler;
import io.github.dft.amazon.model.subscription.v1.SubscriptionRequest;
import io.github.dft.amazon.model.subscription.v1.SubscriptionWrapper;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;

public class AmazonSPSubscriptionsAPI
extends AmazonSellingPartnerSdk {
    public AmazonSPSubscriptionsAPI(AmazonCredentials amazonCredentials) {
        super(amazonCredentials);
    }

    public SubscriptionWrapper createSubscription(String notificationType, SubscriptionRequest subscriptionRequest) {
        URI uri = URI.create(this.sellingRegionEndpoint + "/notifications/v1/subscriptions/" + notificationType);
        String requestBody = this.getString(subscriptionRequest);
        DefaultRequest<Object> signRequest = this.signRequest(String.valueOf(uri), HttpMethodName.POST, null, requestBody);
        HttpRequest request = HttpRequest.newBuilder(uri).header("Accept", "application/json").header("Content-Type", "application/json").header("x-amz-access-token", this.amazonCredentials.getAccessToken()).header("Authorization", (String)signRequest.getHeaders().get("Authorization")).header("X-Amz-Security-Token", (String)signRequest.getHeaders().get("X-Amz-Security-Token")).header("X-Amz-Date", (String)signRequest.getHeaders().get("X-Amz-Date")).POST(HttpRequest.BodyPublishers.ofString(requestBody)).build();
        JsonBodyHandler<SubscriptionWrapper> handler = new JsonBodyHandler<SubscriptionWrapper>(SubscriptionWrapper.class);
        return this.getRequestWrapped(request, handler);
    }

    public SubscriptionWrapper getAllSubscriptionByNotificationType(String notificationType) {
        URI uri = URI.create(this.sellingRegionEndpoint + "/notifications/v1/subscriptions/" + notificationType);
        DefaultRequest<Object> signRequest = this.signRequest(String.valueOf(uri), HttpMethodName.GET, null, null);
        HttpRequest request = HttpRequest.newBuilder(uri).header("Accept", "application/json").header("Content-Type", "application/json").header("x-amz-access-token", this.amazonCredentials.getAccessToken()).header("Authorization", (String)signRequest.getHeaders().get("Authorization")).header("X-Amz-Security-Token", (String)signRequest.getHeaders().get("X-Amz-Security-Token")).header("X-Amz-Date", (String)signRequest.getHeaders().get("X-Amz-Date")).GET().build();
        JsonBodyHandler<SubscriptionWrapper> handler = new JsonBodyHandler<SubscriptionWrapper>(SubscriptionWrapper.class);
        return this.getRequestWrapped(request, handler);
    }

    public SubscriptionWrapper getByNotificationTypeAndSubscriptionId(String notificationType, String subscriptionId) {
        URI uri = URI.create(this.sellingRegionEndpoint + "/notifications/v1/subscriptions/" + notificationType + "/" + subscriptionId);
        DefaultRequest<Object> signRequest = this.signRequest(String.valueOf(uri), HttpMethodName.GET, null, null);
        HttpRequest request = HttpRequest.newBuilder(uri).header("Accept", "application/json").header("Content-Type", "application/json").header("x-amz-access-token", this.amazonCredentials.getAccessToken()).header("Authorization", (String)signRequest.getHeaders().get("Authorization")).header("X-Amz-Security-Token", (String)signRequest.getHeaders().get("X-Amz-Security-Token")).header("X-Amz-Date", (String)signRequest.getHeaders().get("X-Amz-Date")).GET().build();
        JsonBodyHandler<SubscriptionWrapper> handler = new JsonBodyHandler<SubscriptionWrapper>(SubscriptionWrapper.class);
        return this.getRequestWrapped(request, handler);
    }

    public void deleteByNotificationTypeAndSubscriptionId(String notificationType, String subscriptionId) {
        URI uri = URI.create(this.sellingRegionEndpoint + "/notifications/v1/subscriptions/" + notificationType + "/" + subscriptionId);
        DefaultRequest<Object> signRequest = this.signRequest(String.valueOf(uri), HttpMethodName.DELETE, null, null);
        HttpRequest request = HttpRequest.newBuilder(uri).header("Accept", "application/json").header("Content-Type", "application/json").header("x-amz-access-token", this.amazonCredentials.getAccessToken()).header("Authorization", (String)signRequest.getHeaders().get("Authorization")).header("X-Amz-Security-Token", (String)signRequest.getHeaders().get("X-Amz-Security-Token")).header("X-Amz-Date", (String)signRequest.getHeaders().get("X-Amz-Date")).DELETE().build();
        this.getRequestWrapped(request, HttpResponse.BodyHandlers.ofString());
    }
}

