/*
 * Decompiled with CFR 0.152.
 */
package io.github.dft.amazon;

import com.amazonaws.DefaultRequest;
import com.amazonaws.http.HttpMethodName;
import io.github.dft.amazon.AmazonSellingPartnerSdk;
import io.github.dft.amazon.model.AmazonCredentials;
import io.github.dft.amazon.model.feeds.v20210630.CreateFeedDocumentResponse;
import io.github.dft.amazon.model.feeds.v20210630.CreateFeedDocumentSpecification;
import io.github.dft.amazon.model.feeds.v20210630.CreateFeedResponse;
import io.github.dft.amazon.model.feeds.v20210630.CreateFeedSpecification;
import io.github.dft.amazon.model.feeds.v20210630.Feed;
import io.github.dft.amazon.model.feeds.v20210630.FeedDocument;
import io.github.dft.amazon.model.feeds.v20210630.GetFeedsResponse;
import io.github.dft.amazon.model.handler.JsonBodyHandler;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.apache.http.client.utils.URIBuilder;

public class AmazonSPFeeds
extends AmazonSellingPartnerSdk {
    public AmazonSPFeeds(AmazonCredentials amazonCredentials) {
        super(amazonCredentials);
    }

    public GetFeedsResponse getFeeds(HashMap<String, String> params) {
        DefaultRequest<Object> signRequest = this.signRequest("/feeds/2021-06-30/feeds", HttpMethodName.GET, params, null);
        URIBuilder uriBuilder = new URIBuilder(this.sellingRegionEndpoint + "/feeds/2021-06-30/feeds");
        this.addParameters(uriBuilder, params);
        HttpRequest request = HttpRequest.newBuilder(uriBuilder.build()).header("Accept", "application/json").header("Content-Type", "application/json").header("x-amz-access-token", this.amazonCredentials.getAccessToken()).header("Authorization", (String)signRequest.getHeaders().get("Authorization")).header("X-Amz-Security-Token", (String)signRequest.getHeaders().get("X-Amz-Security-Token")).header("X-Amz-Date", (String)signRequest.getHeaders().get("X-Amz-Date")).build();
        JsonBodyHandler<GetFeedsResponse> handler = new JsonBodyHandler<GetFeedsResponse>(GetFeedsResponse.class);
        return this.getRequestWrapped(request, handler);
    }

    public Feed getFeed(String feedId) {
        String feedUrl = "/feeds/2021-06-30/feeds/" + feedId;
        DefaultRequest<Object> signRequest = this.signRequest(feedUrl, HttpMethodName.GET, null, null);
        HttpRequest request = HttpRequest.newBuilder(new URI(this.sellingRegionEndpoint + feedUrl)).header("Accept", "application/json").header("Content-Type", "application/json").header("x-amz-access-token", this.amazonCredentials.getAccessToken()).header("Authorization", (String)signRequest.getHeaders().get("Authorization")).header("X-Amz-Security-Token", (String)signRequest.getHeaders().get("X-Amz-Security-Token")).header("X-Amz-Date", (String)signRequest.getHeaders().get("X-Amz-Date")).build();
        JsonBodyHandler<Feed> handler = new JsonBodyHandler<Feed>(Feed.class);
        return this.getRequestWrapped(request, handler);
    }

    public FeedDocument getFeedDocument(String feedDocumentId) {
        String feedUrl = "/feeds/2021-06-30/documents/" + feedDocumentId;
        DefaultRequest<Object> signRequest = this.signRequest(feedUrl, HttpMethodName.GET, null, null);
        HttpRequest request = HttpRequest.newBuilder(new URI(this.sellingRegionEndpoint + feedUrl)).header("Accept", "application/json").header("Content-Type", "application/json").header("x-amz-access-token", this.amazonCredentials.getAccessToken()).header("Authorization", (String)signRequest.getHeaders().get("Authorization")).header("X-Amz-Security-Token", (String)signRequest.getHeaders().get("X-Amz-Security-Token")).header("X-Amz-Date", (String)signRequest.getHeaders().get("X-Amz-Date")).build();
        JsonBodyHandler<FeedDocument> handler = new JsonBodyHandler<FeedDocument>(FeedDocument.class);
        return this.getRequestWrapped(request, handler);
    }

    public String cancelFeed(String feedId) {
        String feedUrl = "/feeds/2021-06-30/feeds/" + feedId;
        DefaultRequest<Object> signRequest = this.signRequest(feedUrl, HttpMethodName.GET, null, null);
        HttpRequest request = HttpRequest.newBuilder(new URI(this.sellingRegionEndpoint + feedUrl)).header("Accept", "application/json").header("Content-Type", "application/json").header("x-amz-access-token", this.amazonCredentials.getAccessToken()).header("Authorization", (String)signRequest.getHeaders().get("Authorization")).header("X-Amz-Security-Token", (String)signRequest.getHeaders().get("X-Amz-Security-Token")).header("X-Amz-Date", (String)signRequest.getHeaders().get("X-Amz-Date")).DELETE().build();
        return this.client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).get().body();
    }

    public CreateFeedDocumentResponse createFeedDocument(CreateFeedDocumentSpecification createFeedDocumentSpecification) {
        String requestBody = this.getString(createFeedDocumentSpecification);
        DefaultRequest<Object> signRequest = this.signRequest("/feeds/2021-06-30/documents", HttpMethodName.POST, null, requestBody);
        URIBuilder uriBuilder = new URIBuilder(this.sellingRegionEndpoint + "/feeds/2021-06-30/documents");
        HttpRequest request = HttpRequest.newBuilder(uriBuilder.build()).header("Accept", "application/json").header("Content-Type", "application/json").header("x-amz-access-token", this.amazonCredentials.getAccessToken()).header("Authorization", (String)signRequest.getHeaders().get("Authorization")).header("X-Amz-Security-Token", (String)signRequest.getHeaders().get("X-Amz-Security-Token")).header("X-Amz-Date", (String)signRequest.getHeaders().get("X-Amz-Date")).POST(HttpRequest.BodyPublishers.ofString(requestBody)).build();
        JsonBodyHandler<CreateFeedDocumentResponse> handler = new JsonBodyHandler<CreateFeedDocumentResponse>(CreateFeedDocumentResponse.class);
        return this.getRequestWrapped(request, handler);
    }

    public CreateFeedResponse createFeed(CreateFeedSpecification createFeedSpecification) {
        String requestBody = this.getString(createFeedSpecification);
        DefaultRequest<Object> signRequest = this.signRequest("/feeds/2021-06-30/feeds", HttpMethodName.POST, null, requestBody);
        HttpRequest request = HttpRequest.newBuilder(new URI(this.sellingRegionEndpoint + "/feeds/2021-06-30/feeds")).header("Accept", "application/json").header("Content-Type", "application/json").header("x-amz-access-token", this.amazonCredentials.getAccessToken()).header("Authorization", (String)signRequest.getHeaders().get("Authorization")).header("X-Amz-Security-Token", (String)signRequest.getHeaders().get("X-Amz-Security-Token")).header("X-Amz-Date", (String)signRequest.getHeaders().get("X-Amz-Date")).POST(HttpRequest.BodyPublishers.ofString(requestBody)).build();
        JsonBodyHandler<CreateFeedResponse> handler = new JsonBodyHandler<CreateFeedResponse>(CreateFeedResponse.class);
        return this.getRequestWrapped(request, handler);
    }

    public void uploadFeedDocument(String feedUrl, InputStream inputStream) {
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(feedUrl)).POST(HttpRequest.BodyPublishers.ofByteArray(inputStream.readAllBytes())).build();
    }

    public String uploadFeedDocument(String feedUrl, File file, String contentType) {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(feedUrl)).header("Content-Type", contentType).PUT(HttpRequest.BodyPublishers.ofFile(file.toPath())).build();
        return this.client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).get().body();
    }

    public String uploadFeedDocument(String feedUrl, String file, String contentType) {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(feedUrl)).header("Content-Type", contentType).PUT(HttpRequest.BodyPublishers.ofByteArray(file.getBytes(StandardCharsets.UTF_8))).build();
        return this.client.send(request, HttpResponse.BodyHandlers.ofString()).body();
    }
}

