/*
 * Decompiled with CFR 0.152.
 */
package io.github.dayeshing.apiface.gradle;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import io.github.dayeshing.apiface.conver.ToBean;
import io.github.dayeshing.apiface.core.api.meta.Author;
import io.github.dayeshing.apiface.core.api.resolver.ApiResolver;
import io.github.dayeshing.apiface.core.api.resolver.ApiResolverImpl;
import io.github.dayeshing.apiface.core.api.resolver.GetFieldGroupResolver;
import io.github.dayeshing.apiface.core.comment.impl.ClassMark;
import io.github.dayeshing.apiface.core.resolver.tag.AuthorResolver;
import io.github.dayeshing.apiface.core.swagger.v2.Swagger2;
import io.github.dayeshing.apiface.core.util.GZIPUtil;
import io.github.dayeshing.apiface.core.util.ObjectUtil;
import io.github.dayeshing.apiface.gradle.AbstractFaceTask;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ApiTask
extends AbstractFaceTask {
    public static final String MOJO = "api";
    private ApiResolver resolver = null;

    public void loadMark(byte[] bytes) {
        try {
            if (this.apiExtension.isGzip()) {
                this.resolver.resolver(ToBean.toBeans((byte[])GZIPUtil.uncompress((byte[])bytes)));
            } else {
                this.resolver.resolver(JSON.parseArray((String)new String(bytes), ClassMark.class));
            }
        }
        catch (Exception e) {
            this.getLog(String.format("----------->> \u89e3\u538b\u6587\u6863\u5931\u8d25: %s <<-----------", e.getMessage()));
            e.printStackTrace();
        }
    }

    public void loadMark(ClassLoader loader, String pack) {
        Enumeration<URL> resources = null;
        try {
            resources = loader.getResources(pack);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (resources != null) {
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                String protocol = url.getProtocol();
                this.getLog(String.format("----------->> \u6b63\u5728\u52a0\u8f7d\u6587\u4ef6: %s\u3010%s\u3011 <<-----------", url.getPath(), protocol));
                if ("file".equalsIgnoreCase(protocol)) {
                    try {
                        this.loadMark(ObjectUtil.read((InputStream)new FileInputStream(new File(url.getFile()))));
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (!"jar".equalsIgnoreCase(protocol)) continue;
                JarFile jares = null;
                try {
                    jares = ((JarURLConnection)url.openConnection()).getJarFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (jares == null) continue;
                Enumeration<JarEntry> entries = jares.entries();
                while (entries.hasMoreElements()) {
                    String className;
                    JarEntry jarEntry = entries.nextElement();
                    if (jarEntry == null || !(className = jarEntry.getName()).startsWith(pack)) continue;
                    try {
                        this.loadMark(ObjectUtil.read((InputStream)jares.getInputStream(jarEntry)));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    protected byte[] process() {
        this.resolver = new ApiResolverImpl(this.classLoader);
        this.loadMark(this.classLoader, String.format("%s/%s", "apiface", this.getFilename("doc")));
        try {
            Class<?> clazz = Class.forName("com.daysh.apiface.controller.GraldleController", false, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        JSONObject transform = new Swagger2((GetFieldGroupResolver)this.resolver).transform(this.resolver.getActions(), this.resolver.getFields());
        return this.info(transform).toJSONString().getBytes();
    }

    @Override
    protected File dist() {
        return new File(new File(this.project.getBuildDir(), "libs"), this.getFilename(this.project.getName()));
    }

    protected JSONObject info(JSONObject transform) {
        transform.put("swagger", (Object)this.apiExtension.getOwner());
        transform.put("apiface", (Object)"1");
        transform.put("host", (Object)this.apiExtension.getHost());
        transform.put("basePath", (Object)this.apiExtension.getBasePath());
        transform.put("ignoreHost", (Object)this.apiExtension.isIgnoreHost());
        JSONObject info = new JSONObject();
        JSONObject license = new JSONObject();
        license.put("name", (Object)this.apiExtension.getLicense());
        license.put("url", (Object)this.apiExtension.getLicenseUrl());
        info.put("license", (Object)license);
        JSONObject contact = new JSONObject();
        Author author = new AuthorResolver().resolver(Arrays.asList(this.apiExtension.getDeveloper()));
        contact.put("url", (Object)this.apiExtension.getUrl());
        contact.put("name", (Object)author.getName());
        contact.put("email", (Object)author.getContact());
        info.put("contact", (Object)contact);
        info.put("description", (Object)this.apiExtension.getDescription());
        info.put("version", (Object)this.apiExtension.getVersion());
        info.put("title", (Object)this.apiExtension.getTitle());
        info.put("termsOfService", (Object)this.apiExtension.getUrl());
        transform.put("info", (Object)info);
        return transform;
    }

    @Override
    protected String mojo() {
        return MOJO;
    }
}

