/*
 * Decompiled with CFR 0.152.
 */
package io.github.crow_misia.libyuv;

import android.graphics.Rect;
import io.github.crow_misia.libyuv.AbstractBuffer;
import io.github.crow_misia.libyuv.Buffer24;
import io.github.crow_misia.libyuv.BufferExtKt;
import io.github.crow_misia.libyuv.BufferFactory24;
import io.github.crow_misia.libyuv.Capacity;
import io.github.crow_misia.libyuv.CapacityCalculator;
import io.github.crow_misia.libyuv.Plane;
import io.github.crow_misia.libyuv.Plane1Capacities;
import io.github.crow_misia.libyuv.PlanePrimitive;
import io.github.crow_misia.libyuv.RowStride;
import io.github.crow_misia.libyuv.Yuv;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001d2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001\u001dB=\b\u0002\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ/\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\t\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lio/github/crow_misia/libyuv/Yuv24Buffer;", "Lio/github/crow_misia/libyuv/AbstractBuffer;", "Lio/github/crow_misia/libyuv/Buffer24;", "buffer", "Ljava/nio/ByteBuffer;", "plane", "Lio/github/crow_misia/libyuv/Plane;", "width", "", "height", "cropRect", "Landroid/graphics/Rect;", "releaseCallback", "Ljava/lang/Runnable;", "<init>", "(Ljava/nio/ByteBuffer;Lio/github/crow_misia/libyuv/Plane;IILandroid/graphics/Rect;Ljava/lang/Runnable;)V", "getPlane", "()Lio/github/crow_misia/libyuv/Plane;", "getWidth", "()I", "getHeight", "getPlaneOffset", "planeIndex", "rowStride", "Lio/github/crow_misia/libyuv/RowStride;", "left", "top", "getPlaneOffset-fuXAFhI", "(IIII)I", "Factory", "core_release"})
public final class Yuv24Buffer
extends AbstractBuffer
implements Buffer24<Yuv24Buffer> {
    @NotNull
    public static final Factory Factory = new Factory(null);
    @NotNull
    private final Plane plane;
    private final int width;
    private final int height;

    private Yuv24Buffer(ByteBuffer buffer, Plane plane, int width, int height, Rect cropRect, Runnable releaseCallback) {
        Plane[] planeArray = new Plane[]{plane};
        super(buffer, cropRect, planeArray, releaseCallback);
        this.plane = plane;
        this.width = width;
        this.height = height;
    }

    @Override
    @NotNull
    public Plane getPlane() {
        return this.plane;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getPlaneOffset-fuXAFhI(int planeIndex, int rowStride, int left, int top) {
        return RowStride.times-impl(rowStride, top) + left * 3;
    }

    @Override
    public void mirrorTo(@NotNull Yuv24Buffer dst) {
        Buffer24.DefaultImpls.mirrorTo(this, (Buffer24)dst);
    }

    public /* synthetic */ Yuv24Buffer(ByteBuffer buffer, Plane plane, int width, int height, Rect cropRect, Runnable releaseCallback, DefaultConstructorMarker $constructor_marker) {
        this(buffer, plane, width, height, cropRect, releaseCallback);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00040\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J \u0010\u000b\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016J(\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016J(\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u0013"}, d2={"Lio/github/crow_misia/libyuv/Yuv24Buffer$Factory;", "Lio/github/crow_misia/libyuv/BufferFactory24;", "Lio/github/crow_misia/libyuv/Yuv24Buffer;", "Lio/github/crow_misia/libyuv/CapacityCalculator;", "Lio/github/crow_misia/libyuv/Plane1Capacities;", "<init>", "()V", "calculate", "width", "", "height", "allocate", "cropRect", "Landroid/graphics/Rect;", "wrap", "buffer", "Ljava/nio/ByteBuffer;", "plane", "Lio/github/crow_misia/libyuv/Plane;", "core_release"})
    @SourceDebugExtension(value={"SMAP\nYuv24Buffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Yuv24Buffer.kt\nio/github/crow_misia/libyuv/Yuv24Buffer$Factory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n1#2:73\n*E\n"})
    public static final class Factory
    implements BufferFactory24<Yuv24Buffer>,
    CapacityCalculator<Plane1Capacities> {
        private Factory() {
        }

        @Override
        @NotNull
        public Plane1Capacities calculate(int width, int height) {
            int stride = width * 3;
            int capacity = stride * height;
            int n = RowStride.constructor-impl(stride);
            int n2 = Capacity.constructor-impl(capacity);
            return new Plane1Capacities(n2, n, null);
        }

        @Override
        @NotNull
        public Yuv24Buffer allocate(int width, int height, @NotNull Rect cropRect) {
            Intrinsics.checkNotNullParameter((Object)cropRect, (String)"cropRect");
            Plane1Capacities plane1Capacities = this.calculate(width, height);
            int capacity = plane1Capacities.component1-v5S6rBc();
            int stride = plane1Capacities.component2-BElzS_M();
            ByteBuffer buffer = BufferExtKt.createByteBuffer(CollectionsKt.listOf((Object)Capacity.box-impl(capacity)))[0];
            return new Yuv24Buffer(buffer, new PlanePrimitive(stride, buffer, 0, 4, null), width, height, cropRect, () -> Factory.allocate$lambda$0(buffer), null);
        }

        @Override
        @NotNull
        public Yuv24Buffer wrap(@NotNull ByteBuffer buffer, int width, int height, @NotNull Rect cropRect) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            Intrinsics.checkNotNullParameter((Object)cropRect, (String)"cropRect");
            if (!buffer.isDirect()) {
                boolean $i$a$-check-Yuv24Buffer$Factory$wrap$22 = false;
                String $i$a$-check-Yuv24Buffer$Factory$wrap$22 = "Unsupported non-direct ByteBuffer.";
                throw new IllegalStateException($i$a$-check-Yuv24Buffer$Factory$wrap$22.toString());
            }
            Plane1Capacities plane1Capacities = this.calculate(width, height);
            int capacity = plane1Capacities.component1-v5S6rBc();
            int stride = plane1Capacities.component2-BElzS_M();
            ByteBuffer sliceBuffer = BufferExtKt.sliceRange(buffer, 0, capacity);
            return new Yuv24Buffer(sliceBuffer, new PlanePrimitive(stride, sliceBuffer, 0, 4, null), width, height, cropRect, null, null);
        }

        @Override
        @NotNull
        public Yuv24Buffer wrap(@NotNull Plane plane, int width, int height, @NotNull Rect cropRect) {
            Intrinsics.checkNotNullParameter((Object)plane, (String)"plane");
            Intrinsics.checkNotNullParameter((Object)cropRect, (String)"cropRect");
            return new Yuv24Buffer(plane.getBuffer(), plane, width, height, cropRect, null, null);
        }

        @Override
        @NotNull
        public Yuv24Buffer wrap(@NotNull Plane plane, int width, int height) {
            return BufferFactory24.DefaultImpls.wrap(this, plane, width, height);
        }

        @Override
        @NotNull
        public Yuv24Buffer wrap(@NotNull ByteBuffer buffer, int width, int height) {
            return BufferFactory24.DefaultImpls.wrap(this, buffer, width, height);
        }

        @Override
        @NotNull
        public Yuv24Buffer allocate(int width, int height) {
            return BufferFactory24.DefaultImpls.allocate(this, width, height);
        }

        private static final void allocate$lambda$0(ByteBuffer $buffer) {
            Yuv.INSTANCE.freeNativeBuffer($buffer);
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

