/*
 * Decompiled with CFR 0.152.
 */
package io.github.crow_misia.libyuv;

import android.graphics.Rect;
import io.github.crow_misia.libyuv.AbstractBuffer;
import io.github.crow_misia.libyuv.ArgbBuffer;
import io.github.crow_misia.libyuv.Buffer32;
import io.github.crow_misia.libyuv.BufferExtKt;
import io.github.crow_misia.libyuv.BufferFactory;
import io.github.crow_misia.libyuv.FilterMode;
import io.github.crow_misia.libyuv.I420Buffer;
import io.github.crow_misia.libyuv.J400Buffer;
import io.github.crow_misia.libyuv.Plane;
import io.github.crow_misia.libyuv.PlanePrimitive;
import io.github.crow_misia.libyuv.RotateMode;
import io.github.crow_misia.libyuv.Yuv;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001\u0018B1\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0016J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0017R\u0014\u0010\t\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lio/github/crow_misia/libyuv/RgbaBuffer;", "Lio/github/crow_misia/libyuv/AbstractBuffer;", "Lio/github/crow_misia/libyuv/Buffer32;", "buffer", "Ljava/nio/ByteBuffer;", "plane", "Lio/github/crow_misia/libyuv/Plane;", "width", "", "height", "releaseCallback", "Ljava/lang/Runnable;", "(Ljava/nio/ByteBuffer;Lio/github/crow_misia/libyuv/Plane;IILjava/lang/Runnable;)V", "getHeight", "()I", "getPlane", "()Lio/github/crow_misia/libyuv/Plane;", "getWidth", "convertTo", "", "dst", "Lio/github/crow_misia/libyuv/ArgbBuffer;", "Lio/github/crow_misia/libyuv/I420Buffer;", "Lio/github/crow_misia/libyuv/J400Buffer;", "Factory", "core_release"})
public final class RgbaBuffer
extends AbstractBuffer
implements Buffer32<RgbaBuffer> {
    @NotNull
    public static final Factory Factory = new Factory(null);
    @NotNull
    private final Plane plane;
    private final int width;
    private final int height;

    private RgbaBuffer(ByteBuffer buffer, Plane plane, int width, int height, Runnable releaseCallback) {
        Plane[] planeArray = new Plane[]{plane};
        super(buffer, planeArray, releaseCallback);
        this.plane = plane;
        this.width = width;
        this.height = height;
    }

    @Override
    @NotNull
    public Plane getPlane() {
        return this.plane;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public final void convertTo(@NotNull I420Buffer dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Yuv.INSTANCE.convertRGBAToI420(this.getPlane().getBuffer(), this.getPlane().getRowStride(), dst.getPlaneY().getBuffer(), dst.getPlaneY().getRowStride(), dst.getPlaneU().getBuffer(), dst.getPlaneU().getRowStride(), dst.getPlaneV().getBuffer(), dst.getPlaneV().getRowStride(), Math.min(this.getWidth(), dst.getWidth()), Math.min(this.getHeight(), dst.getHeight()));
    }

    @Override
    public final void convertTo(@NotNull J400Buffer dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Yuv.INSTANCE.convertRGBAToJ400(this.getPlane().getBuffer(), this.getPlane().getRowStride(), dst.getPlaneY().getBuffer(), dst.getPlaneY().getRowStride(), Math.min(this.getWidth(), dst.getWidth()), Math.min(this.getHeight(), dst.getHeight()));
    }

    @Override
    public final void convertTo(@NotNull ArgbBuffer dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Yuv.INSTANCE.convertRGBAToARGB(this.getPlane().getBuffer(), this.getPlane().getRowStride(), dst.getPlane().getBuffer(), dst.getPlane().getRowStride(), Math.min(this.getWidth(), dst.getWidth()), Math.min(this.getHeight(), dst.getHeight()));
    }

    @Override
    public void convertTo(@NotNull RgbaBuffer dst) {
        Buffer32.DefaultImpls.convertTo(this, (Buffer32)dst);
    }

    @Override
    public void mirrorTo(@NotNull RgbaBuffer dst) {
        Buffer32.DefaultImpls.mirrorTo(this, (Buffer32)dst);
    }

    @Override
    public void rotate(@NotNull RgbaBuffer dst, @NotNull RotateMode rotateMode) {
        Buffer32.DefaultImpls.rotate(this, (Buffer32)dst, rotateMode);
    }

    @Override
    public void scale(@NotNull RgbaBuffer dst, @NotNull FilterMode filterMode) {
        Buffer32.DefaultImpls.scale(this, (Buffer32)dst, filterMode);
    }

    @Override
    public void scaleClip(@NotNull RgbaBuffer dst, @NotNull Rect rect, @NotNull FilterMode filterMode) {
        Buffer32.DefaultImpls.scaleClip(this, (Buffer32)dst, rect, filterMode);
    }

    public /* synthetic */ RgbaBuffer(ByteBuffer buffer, Plane plane, int width, int height, Runnable releaseCallback, DefaultConstructorMarker $constructor_marker) {
        this(buffer, plane, width, height, releaseCallback);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u001e\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J \u0010\n\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a8\u0006\u000f"}, d2={"Lio/github/crow_misia/libyuv/RgbaBuffer$Factory;", "Lio/github/crow_misia/libyuv/BufferFactory;", "Lio/github/crow_misia/libyuv/RgbaBuffer;", "()V", "allocate", "width", "", "height", "getStrideWithCapacity", "", "wrap", "plane", "Lio/github/crow_misia/libyuv/Plane;", "buffer", "Ljava/nio/ByteBuffer;", "core_release"})
    @SourceDebugExtension(value={"SMAP\nRgbaBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RgbaBuffer.kt\nio/github/crow_misia/libyuv/RgbaBuffer$Factory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n1#2:88\n*E\n"})
    public static final class Factory
    implements BufferFactory<RgbaBuffer> {
        private Factory() {
        }

        private final int[] getStrideWithCapacity(int width, int height) {
            int stride = width << 2;
            int capacity = stride * height;
            int[] nArray = new int[]{stride, capacity};
            return nArray;
        }

        @Override
        @NotNull
        public RgbaBuffer allocate(int width, int height) {
            int[] nArray = this.getStrideWithCapacity(width, height);
            int stride = nArray[0];
            int capacity = nArray[1];
            ByteBuffer buffer = BufferExtKt.createByteBuffer(capacity);
            return new RgbaBuffer(buffer, new PlanePrimitive(stride, buffer), width, height, () -> Factory.allocate$lambda$0(buffer), null);
        }

        @Override
        @NotNull
        public RgbaBuffer wrap(@NotNull ByteBuffer buffer, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            if (!buffer.isDirect()) {
                boolean $i$a$-check-RgbaBuffer$Factory$wrap$22 = false;
                String $i$a$-check-RgbaBuffer$Factory$wrap$22 = "Unsupported non-direct ByteBuffer.";
                throw new IllegalStateException($i$a$-check-RgbaBuffer$Factory$wrap$22.toString());
            }
            int[] nArray = this.getStrideWithCapacity(width, height);
            int stride = nArray[0];
            int capacity = nArray[1];
            ByteBuffer sliceBuffer = BufferExtKt.sliceRange(buffer, 0, capacity);
            return new RgbaBuffer(sliceBuffer, new PlanePrimitive(stride, sliceBuffer), width, height, null, null);
        }

        @NotNull
        public final RgbaBuffer wrap(@NotNull Plane plane, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)plane, (String)"plane");
            return new RgbaBuffer(plane.getBuffer(), plane, width, height, null, null);
        }

        private static final void allocate$lambda$0(ByteBuffer $buffer) {
            Intrinsics.checkNotNullParameter((Object)$buffer, (String)"$buffer");
            Yuv.INSTANCE.freeNativeBuffer($buffer);
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

