/*
 * Decompiled with CFR 0.152.
 */
package io.github.crow_misia.libyuv;

import io.github.crow_misia.libyuv.AbstractBuffer;
import io.github.crow_misia.libyuv.Buffer24;
import io.github.crow_misia.libyuv.BufferExtKt;
import io.github.crow_misia.libyuv.BufferFactory;
import io.github.crow_misia.libyuv.Plane;
import io.github.crow_misia.libyuv.PlanePrimitive;
import io.github.crow_misia.libyuv.Yuv;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u00122\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001\u0012B3\b\u0002\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fR\u0014\u0010\t\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lio/github/crow_misia/libyuv/Yuv24Buffer;", "Lio/github/crow_misia/libyuv/AbstractBuffer;", "Lio/github/crow_misia/libyuv/Buffer24;", "buffer", "Ljava/nio/ByteBuffer;", "plane", "Lio/github/crow_misia/libyuv/Plane;", "width", "", "height", "releaseCallback", "Ljava/lang/Runnable;", "(Ljava/nio/ByteBuffer;Lio/github/crow_misia/libyuv/Plane;IILjava/lang/Runnable;)V", "getHeight", "()I", "getPlane", "()Lio/github/crow_misia/libyuv/Plane;", "getWidth", "Factory", "libyuv-android"})
public final class Yuv24Buffer
extends AbstractBuffer
implements Buffer24<Yuv24Buffer> {
    @NotNull
    public static final Factory Factory = new Factory(null);
    @NotNull
    private final Plane plane;
    private final int width;
    private final int height;

    private Yuv24Buffer(ByteBuffer buffer, Plane plane, int width, int height, Runnable releaseCallback) {
        Plane[] planeArray = new Plane[]{plane};
        super(buffer, planeArray, releaseCallback);
        this.plane = plane;
        this.width = width;
        this.height = height;
    }

    @Override
    @NotNull
    public Plane getPlane() {
        return this.plane;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void mirrorTo(@NotNull Yuv24Buffer dst) {
        Buffer24.DefaultImpls.mirrorTo(this, (Buffer24)dst);
    }

    public /* synthetic */ Yuv24Buffer(ByteBuffer buffer, Plane plane, int width, int height, Runnable releaseCallback, DefaultConstructorMarker $constructor_marker) {
        this(buffer, plane, width, height, releaseCallback);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u001e\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J \u0010\n\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a8\u0006\u000f"}, d2={"Lio/github/crow_misia/libyuv/Yuv24Buffer$Factory;", "Lio/github/crow_misia/libyuv/BufferFactory;", "Lio/github/crow_misia/libyuv/Yuv24Buffer;", "()V", "allocate", "width", "", "height", "getStrideWithCapacity", "", "wrap", "plane", "Lio/github/crow_misia/libyuv/Plane;", "buffer", "Ljava/nio/ByteBuffer;", "libyuv-android"})
    public static final class Factory
    implements BufferFactory<Yuv24Buffer> {
        private Factory() {
        }

        private final int[] getStrideWithCapacity(int width, int height) {
            int stride = width * 3;
            int capacity = stride * height;
            int[] nArray = new int[]{stride, capacity};
            return nArray;
        }

        @Override
        @NotNull
        public Yuv24Buffer allocate(int width, int height) {
            int[] nArray = this.getStrideWithCapacity(width, height);
            int stride = nArray[0];
            int capacity = nArray[1];
            ByteBuffer buffer = BufferExtKt.createByteBuffer(capacity);
            return new Yuv24Buffer(buffer, new PlanePrimitive(stride, buffer), width, height, () -> Factory.allocate$lambda-0(buffer), null);
        }

        @Override
        @NotNull
        public Yuv24Buffer wrap(@NotNull ByteBuffer buffer, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            if (!buffer.isDirect()) {
                boolean $i$a$-check-Yuv24Buffer$Factory$wrap$22 = false;
                String $i$a$-check-Yuv24Buffer$Factory$wrap$22 = "Unsupported non-direct ByteBuffer.";
                throw new IllegalStateException($i$a$-check-Yuv24Buffer$Factory$wrap$22.toString());
            }
            int[] nArray = this.getStrideWithCapacity(width, height);
            int stride = nArray[0];
            int capacity = nArray[1];
            ByteBuffer sliceBuffer = BufferExtKt.sliceRange(buffer, 0, capacity);
            return new Yuv24Buffer(sliceBuffer, new PlanePrimitive(stride, sliceBuffer), width, height, null, null);
        }

        @NotNull
        public final Yuv24Buffer wrap(@NotNull Plane plane, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)plane, (String)"plane");
            return new Yuv24Buffer(plane.getBuffer(), plane, width, height, null, null);
        }

        private static final void allocate$lambda-0(ByteBuffer $buffer) {
            Intrinsics.checkNotNullParameter((Object)$buffer, (String)"$buffer");
            Yuv.INSTANCE.freeNativeBuffer($buffer);
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

