/*
 * Decompiled with CFR 0.152.
 */
package io.github.crow_misia.libyuv;

import io.github.crow_misia.libyuv.AbgrBuffer;
import io.github.crow_misia.libyuv.AbstractBuffer;
import io.github.crow_misia.libyuv.ArgbBuffer;
import io.github.crow_misia.libyuv.BufferExtKt;
import io.github.crow_misia.libyuv.BufferFactory;
import io.github.crow_misia.libyuv.BufferY;
import io.github.crow_misia.libyuv.FilterMode;
import io.github.crow_misia.libyuv.I400Buffer;
import io.github.crow_misia.libyuv.I420Buffer;
import io.github.crow_misia.libyuv.Nv12Buffer;
import io.github.crow_misia.libyuv.Plane;
import io.github.crow_misia.libyuv.PlanePrimitive;
import io.github.crow_misia.libyuv.RawBuffer;
import io.github.crow_misia.libyuv.Rgb24Buffer;
import io.github.crow_misia.libyuv.RotateMode;
import io.github.crow_misia.libyuv.Yuv;
import io.github.crow_misia.libyuv.Yuv24Buffer;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 &2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001&B;\b\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0019J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001aJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001bJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0000J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001cJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001dJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0000J\u0016\u0010 \u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\"J\u0016\u0010 \u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"J\u0016\u0010 \u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\"J\u0016\u0010#\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00002\u0006\u0010$\u001a\u00020%R\u0014\u0010\u000b\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010\u00a8\u0006'"}, d2={"Lio/github/crow_misia/libyuv/Nv21Buffer;", "Lio/github/crow_misia/libyuv/AbstractBuffer;", "Lio/github/crow_misia/libyuv/BufferY;", "Lio/github/crow_misia/libyuv/I400Buffer;", "buffer", "Ljava/nio/ByteBuffer;", "planeY", "Lio/github/crow_misia/libyuv/Plane;", "planeVU", "width", "", "height", "releaseCallback", "Ljava/lang/Runnable;", "(Ljava/nio/ByteBuffer;Lio/github/crow_misia/libyuv/Plane;Lio/github/crow_misia/libyuv/Plane;IILjava/lang/Runnable;)V", "getHeight", "()I", "getPlaneVU", "()Lio/github/crow_misia/libyuv/Plane;", "getPlaneY", "getWidth", "convertTo", "", "dst", "Lio/github/crow_misia/libyuv/AbgrBuffer;", "Lio/github/crow_misia/libyuv/ArgbBuffer;", "Lio/github/crow_misia/libyuv/I420Buffer;", "Lio/github/crow_misia/libyuv/Nv12Buffer;", "Lio/github/crow_misia/libyuv/RawBuffer;", "Lio/github/crow_misia/libyuv/Rgb24Buffer;", "Lio/github/crow_misia/libyuv/Yuv24Buffer;", "mirrorTo", "rotate", "rotateMode", "Lio/github/crow_misia/libyuv/RotateMode;", "scale", "filterMode", "Lio/github/crow_misia/libyuv/FilterMode;", "Factory", "libyuv-android"})
public final class Nv21Buffer
extends AbstractBuffer
implements BufferY<I400Buffer> {
    @NotNull
    public static final Factory Factory = new Factory(null);
    @NotNull
    private final Plane planeY;
    @NotNull
    private final Plane planeVU;
    private final int width;
    private final int height;

    private Nv21Buffer(ByteBuffer buffer, Plane planeY, Plane planeVU, int width, int height, Runnable releaseCallback) {
        Plane[] planeArray = new Plane[]{planeY, planeVU};
        super(buffer, planeArray, releaseCallback);
        this.planeY = planeY;
        this.planeVU = planeVU;
        this.width = width;
        this.height = height;
    }

    @Override
    @NotNull
    public Plane getPlaneY() {
        return this.planeY;
    }

    @NotNull
    public final Plane getPlaneVU() {
        return this.planeVU;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public final void convertTo(@NotNull I420Buffer dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Yuv.INSTANCE.convertNV21ToI420(this.getPlaneY().getBuffer(), this.getPlaneY().getRowStride(), this.planeVU.getBuffer(), this.planeVU.getRowStride(), dst.getPlaneY().getBuffer(), dst.getPlaneY().getRowStride(), dst.getPlaneU().getBuffer(), dst.getPlaneU().getRowStride(), dst.getPlaneV().getBuffer(), dst.getPlaneV().getRowStride(), Math.min(this.getWidth(), dst.getWidth()), Math.min(this.getHeight(), dst.getHeight()));
    }

    @Override
    public final void convertTo(@NotNull Nv12Buffer dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Yuv.INSTANCE.planerNV21ToNV12(this.getPlaneY().getBuffer(), this.getPlaneY().getRowStride(), this.planeVU.getBuffer(), this.planeVU.getRowStride(), dst.getPlaneY().getBuffer(), dst.getPlaneY().getRowStride(), dst.getPlaneUV().getBuffer(), dst.getPlaneUV().getRowStride(), Math.min(this.getWidth(), dst.getWidth()), Math.min(this.getHeight(), dst.getHeight()));
    }

    @Override
    public final void convertTo(@NotNull Nv21Buffer dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Yuv.INSTANCE.planerNV12Copy(this.getPlaneY().getBuffer(), this.getPlaneY().getRowStride(), this.planeVU.getBuffer(), this.planeVU.getRowStride(), dst.getPlaneY().getBuffer(), dst.getPlaneY().getRowStride(), dst.planeVU.getBuffer(), dst.planeVU.getRowStride(), Math.min(this.getWidth(), dst.getWidth()), Math.min(this.getHeight(), dst.getHeight()));
    }

    @Override
    public final void convertTo(@NotNull ArgbBuffer dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Yuv.INSTANCE.convertNV21ToARGB(this.getPlaneY().getBuffer(), this.getPlaneY().getRowStride(), this.planeVU.getBuffer(), this.planeVU.getRowStride(), dst.getPlane().getBuffer(), dst.getPlane().getRowStride(), Math.min(this.getWidth(), dst.getWidth()), Math.min(this.getHeight(), dst.getHeight()));
    }

    @Override
    public final void convertTo(@NotNull AbgrBuffer dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Yuv.INSTANCE.convertNV21ToABGR(this.getPlaneY().getBuffer(), this.getPlaneY().getRowStride(), this.planeVU.getBuffer(), this.planeVU.getRowStride(), dst.getPlane().getBuffer(), dst.getPlane().getRowStride(), Math.min(this.getWidth(), dst.getWidth()), Math.min(this.getHeight(), dst.getHeight()));
    }

    @Override
    public final void convertTo(@NotNull Rgb24Buffer dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Yuv.INSTANCE.convertNV21ToRGB24(this.getPlaneY().getBuffer(), this.getPlaneY().getRowStride(), this.planeVU.getBuffer(), this.planeVU.getRowStride(), dst.getPlane().getBuffer(), dst.getPlane().getRowStride(), Math.min(this.getWidth(), dst.getWidth()), Math.min(this.getHeight(), dst.getHeight()));
    }

    @Override
    public final void convertTo(@NotNull Yuv24Buffer dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Yuv.INSTANCE.convertNV21ToYUV24(this.getPlaneY().getBuffer(), this.getPlaneY().getRowStride(), this.planeVU.getBuffer(), this.planeVU.getRowStride(), dst.getPlane().getBuffer(), dst.getPlane().getRowStride(), Math.min(this.getWidth(), dst.getWidth()), Math.min(this.getHeight(), dst.getHeight()));
    }

    @Override
    public final void convertTo(@NotNull RawBuffer dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Yuv.INSTANCE.convertNV21ToRAW(this.getPlaneY().getBuffer(), this.getPlaneY().getRowStride(), this.planeVU.getBuffer(), this.planeVU.getRowStride(), dst.getPlane().getBuffer(), dst.getPlane().getRowStride(), Math.min(this.getWidth(), dst.getWidth()), Math.min(this.getHeight(), dst.getHeight()));
    }

    public final void mirrorTo(@NotNull Nv21Buffer dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Yuv.INSTANCE.planerNV12Mirror(this.getPlaneY().getBuffer(), this.getPlaneY().getRowStride(), this.planeVU.getBuffer(), this.planeVU.getRowStride(), dst.getPlaneY().getBuffer(), dst.getPlaneY().getRowStride(), dst.planeVU.getBuffer(), dst.planeVU.getRowStride(), Math.min(this.getWidth(), dst.getWidth()), Math.min(this.getHeight(), dst.getHeight()));
    }

    public final void rotate(@NotNull I420Buffer dst, @NotNull RotateMode rotateMode) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Intrinsics.checkNotNullParameter((Object)((Object)rotateMode), (String)"rotateMode");
        Yuv.INSTANCE.rotateNV12ToI420Rotate(this.getPlaneY().getBuffer(), this.getPlaneY().getRowStride(), this.planeVU.getBuffer(), this.planeVU.getRowStride(), dst.getPlaneY().getBuffer(), dst.getPlaneY().getRowStride(), dst.getPlaneV().getBuffer(), dst.getPlaneV().getRowStride(), dst.getPlaneU().getBuffer(), dst.getPlaneU().getRowStride(), rotateMode.calculateWidth$libyuv_android(this, dst), rotateMode.calculateHeight$libyuv_android(this, dst), rotateMode.getDegrees());
    }

    public final void rotate(@NotNull Nv12Buffer dst, @NotNull RotateMode rotateMode) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Intrinsics.checkNotNullParameter((Object)((Object)rotateMode), (String)"rotateMode");
        Yuv.INSTANCE.rotateNV12ToNV21Rotate(this.getPlaneY().getBuffer(), this.getPlaneY().getRowStride(), this.planeVU.getBuffer(), this.planeVU.getRowStride(), dst.getPlaneY().getBuffer(), dst.getPlaneY().getRowStride(), dst.getPlaneUV().getBuffer(), dst.getPlaneUV().getRowStride(), rotateMode.calculateWidth$libyuv_android(this, dst), rotateMode.calculateHeight$libyuv_android(this, dst), rotateMode.getDegrees());
    }

    public final void rotate(@NotNull Nv21Buffer dst, @NotNull RotateMode rotateMode) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Intrinsics.checkNotNullParameter((Object)((Object)rotateMode), (String)"rotateMode");
        Yuv.INSTANCE.rotateNV21Rotate(this.getPlaneY().getBuffer(), this.getPlaneY().getRowStride(), this.planeVU.getBuffer(), this.planeVU.getRowStride(), dst.getPlaneY().getBuffer(), dst.getPlaneY().getRowStride(), dst.planeVU.getBuffer(), dst.planeVU.getRowStride(), rotateMode.calculateWidth$libyuv_android(this, dst), rotateMode.calculateHeight$libyuv_android(this, dst), rotateMode.getDegrees());
    }

    public final void scale(@NotNull Nv21Buffer dst, @NotNull FilterMode filterMode) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Intrinsics.checkNotNullParameter((Object)((Object)filterMode), (String)"filterMode");
        Yuv.INSTANCE.scaleNV12Scale(this.getPlaneY().getBuffer(), this.getPlaneY().getRowStride(), this.planeVU.getBuffer(), this.planeVU.getRowStride(), this.getWidth(), this.getHeight(), dst.getPlaneY().getBuffer(), dst.getPlaneY().getRowStride(), dst.planeVU.getBuffer(), dst.planeVU.getRowStride(), dst.getWidth(), dst.getHeight(), filterMode.getMode());
    }

    @Override
    public void convertTo(@NotNull I400Buffer dst) {
        BufferY.DefaultImpls.convertTo(this, (BufferY)dst);
    }

    public /* synthetic */ Nv21Buffer(ByteBuffer buffer, Plane planeY, Plane planeVU, int width, int height, Runnable releaseCallback, DefaultConstructorMarker $constructor_marker) {
        this(buffer, planeY, planeVU, width, height, releaseCallback);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J&\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J \u0010\n\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a8\u0006\u0010"}, d2={"Lio/github/crow_misia/libyuv/Nv21Buffer$Factory;", "Lio/github/crow_misia/libyuv/BufferFactory;", "Lio/github/crow_misia/libyuv/Nv21Buffer;", "()V", "allocate", "width", "", "height", "getStrideWithCapacity", "", "wrap", "planeY", "Lio/github/crow_misia/libyuv/Plane;", "planeVU", "buffer", "Ljava/nio/ByteBuffer;", "libyuv-android"})
    public static final class Factory
    implements BufferFactory<Nv21Buffer> {
        private Factory() {
        }

        private final int[] getStrideWithCapacity(int width, int height) {
            int capacityY = width * height;
            int capacityVU = (width + 1 >> 1) * height;
            int[] nArray = new int[]{width, capacityY, width, capacityVU};
            return nArray;
        }

        @Override
        @NotNull
        public Nv21Buffer allocate(int width, int height) {
            int[] nArray = this.getStrideWithCapacity(width, height);
            int strideY = nArray[0];
            int capacityY = nArray[1];
            int strideVU = nArray[2];
            int capacityVU = nArray[3];
            ByteBuffer buffer = BufferExtKt.createByteBuffer(capacityY + capacityVU);
            int[] nArray2 = new int[]{capacityY, capacityVU};
            ByteBuffer[] byteBufferArray = BufferExtKt.slice(buffer, nArray2);
            ByteBuffer bufferY = byteBufferArray[0];
            ByteBuffer bufferVU = byteBufferArray[1];
            return new Nv21Buffer(buffer, new PlanePrimitive(strideY, bufferY), new PlanePrimitive(strideVU, bufferVU), width, height, () -> Factory.allocate$lambda-0(buffer), null);
        }

        @Override
        @NotNull
        public Nv21Buffer wrap(@NotNull ByteBuffer buffer, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            if (!buffer.isDirect()) {
                boolean $i$a$-check-Nv21Buffer$Factory$wrap$22 = false;
                String $i$a$-check-Nv21Buffer$Factory$wrap$22 = "Unsupported non-direct ByteBuffer.";
                throw new IllegalStateException($i$a$-check-Nv21Buffer$Factory$wrap$22.toString());
            }
            int[] nArray = this.getStrideWithCapacity(width, height);
            int strideY = nArray[0];
            int capacityY = nArray[1];
            int strideVU = nArray[2];
            int capacityVU = nArray[3];
            int[] nArray2 = new int[]{capacityY, capacityVU};
            ByteBuffer[] byteBufferArray = BufferExtKt.slice(buffer, nArray2);
            ByteBuffer bufferY = byteBufferArray[0];
            ByteBuffer bufferVU = byteBufferArray[1];
            return new Nv21Buffer(buffer, new PlanePrimitive(strideY, bufferY), new PlanePrimitive(strideVU, bufferVU), width, height, null, null);
        }

        @NotNull
        public final Nv21Buffer wrap(@NotNull Plane planeY, @NotNull Plane planeVU, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)planeY, (String)"planeY");
            Intrinsics.checkNotNullParameter((Object)planeVU, (String)"planeVU");
            return new Nv21Buffer(null, planeY, planeVU, width, height, null, null);
        }

        private static final void allocate$lambda-0(ByteBuffer $buffer) {
            Intrinsics.checkNotNullParameter((Object)$buffer, (String)"$buffer");
            Yuv.INSTANCE.freeNativeBuffer($buffer);
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

