/*
 * Decompiled with CFR 0.152.
 */
package io.github.crow_misia.libyuv;

import android.graphics.Bitmap;
import io.github.crow_misia.libyuv.AbgrBuffer;
import io.github.crow_misia.libyuv.AbstractBuffer;
import io.github.crow_misia.libyuv.BufferExtKt;
import io.github.crow_misia.libyuv.ConvertKt;
import io.github.crow_misia.libyuv.Yuv;
import java.io.Closeable;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eBI\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0003H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001a\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001bH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\n\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\b\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0014\u0010\t\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lio/github/crow_misia/libyuv/Nv21Buffer;", "Lio/github/crow_misia/libyuv/AbstractBuffer;", "buffer", "Ljava/nio/ByteBuffer;", "bufferY", "bufferVU", "strideY", "", "strideVU", "width", "height", "releaseCallback", "Ljava/lang/Runnable;", "(Ljava/nio/ByteBuffer;Ljava/nio/ByteBuffer;Ljava/nio/ByteBuffer;IIIILjava/lang/Runnable;)V", "getBuffer$libyuv_android", "()Ljava/nio/ByteBuffer;", "getBufferVU", "getBufferY", "getHeight", "()I", "getStrideVU$libyuv_android", "getStrideY$libyuv_android", "getWidth", "asBitmap", "Landroid/graphics/Bitmap;", "asBuffer", "asByteArray", "", "", "dst", "Companion", "libyuv-android"})
public final class Nv21Buffer
extends AbstractBuffer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteBuffer buffer;
    @NotNull
    private final ByteBuffer bufferY;
    @NotNull
    private final ByteBuffer bufferVU;
    private final int strideY;
    private final int strideVU;
    private final int width;
    private final int height;

    private Nv21Buffer(ByteBuffer buffer, ByteBuffer bufferY, ByteBuffer bufferVU, int strideY, int strideVU, int width, int height, Runnable releaseCallback) {
        super(releaseCallback);
        this.buffer = buffer;
        this.bufferY = bufferY;
        this.bufferVU = bufferVU;
        this.strideY = strideY;
        this.strideVU = strideVU;
        this.width = width;
        this.height = height;
    }

    @NotNull
    public final ByteBuffer getBuffer$libyuv_android() {
        return this.buffer;
    }

    @NotNull
    public final ByteBuffer getBufferY() {
        return this.bufferY;
    }

    @NotNull
    public final ByteBuffer getBufferVU() {
        return this.bufferVU;
    }

    public final int getStrideY$libyuv_android() {
        return this.strideY;
    }

    public final int getStrideVU$libyuv_android() {
        return this.strideVU;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    @NotNull
    public ByteBuffer asBuffer() {
        return this.buffer;
    }

    @Override
    @NotNull
    public byte[] asByteArray() {
        return BufferExtKt.asByteArray(this.buffer);
    }

    @Override
    public void asByteArray(@NotNull byte[] dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        BufferExtKt.asByteArray(this.buffer, dst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bitmap asBitmap() {
        Bitmap bitmap;
        Closeable closeable = AbgrBuffer.Companion.allocate(this.getWidth(), this.getHeight());
        Throwable throwable = null;
        try {
            AbgrBuffer it = (AbgrBuffer)closeable;
            boolean bl = false;
            ConvertKt.convert(this, it);
            bitmap = it.asBitmap();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return bitmap;
    }

    @JvmStatic
    @NotNull
    public static final int[] getStrideWithCapacity(int width, int height) {
        return Companion.getStrideWithCapacity(width, height);
    }

    @JvmStatic
    @NotNull
    public static final Nv21Buffer allocate(int width, int height) {
        return Companion.allocate(width, height);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Nv21Buffer wrap(@NotNull ByteBuffer buffer, int width, int height, @Nullable Runnable releaseCallback) {
        return Companion.wrap(buffer, width, height, releaseCallback);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Nv21Buffer wrap(@NotNull ByteBuffer buffer, int width, int height) {
        return Companion.wrap(buffer, width, height);
    }

    public /* synthetic */ Nv21Buffer(ByteBuffer buffer, ByteBuffer bufferY, ByteBuffer bufferVU, int strideY, int strideVU, int width, int height, Runnable releaseCallback, DefaultConstructorMarker $constructor_marker) {
        this(buffer, bufferY, bufferVU, strideY, strideVU, width, height, releaseCallback);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J,\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007\u00a8\u0006\u000f"}, d2={"Lio/github/crow_misia/libyuv/Nv21Buffer$Companion;", "", "()V", "allocate", "Lio/github/crow_misia/libyuv/Nv21Buffer;", "width", "", "height", "getStrideWithCapacity", "", "wrap", "buffer", "Ljava/nio/ByteBuffer;", "releaseCallback", "Ljava/lang/Runnable;", "libyuv-android"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final int[] getStrideWithCapacity(int width, int height) {
            int capacityY = width * height;
            int capacityVU = (width + 1 >> 1) * height;
            int[] nArray = new int[]{width, capacityY, width, capacityVU};
            return nArray;
        }

        @JvmStatic
        @NotNull
        public final Nv21Buffer allocate(int width, int height) {
            int[] nArray = this.getStrideWithCapacity(width, height);
            int strideY = nArray[0];
            int capacityY = nArray[1];
            int strideVU = nArray[2];
            int capacityVU = nArray[3];
            ByteBuffer buffer = BufferExtKt.createByteBuffer(capacityY + capacityVU);
            int[] nArray2 = new int[]{capacityY, capacityVU};
            ByteBuffer[] byteBufferArray = BufferExtKt.slice(buffer, nArray2);
            ByteBuffer bufferY = byteBufferArray[0];
            ByteBuffer bufferVU = byteBufferArray[1];
            return new Nv21Buffer(buffer, bufferY, bufferVU, strideY, strideVU, width, height, () -> Companion.allocate$lambda-0(buffer), null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Nv21Buffer wrap(@NotNull ByteBuffer buffer, int width, int height, @Nullable Runnable releaseCallback) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            int[] nArray = this.getStrideWithCapacity(width, height);
            int strideY = nArray[0];
            int capacityY = nArray[1];
            int strideVU = nArray[2];
            int capacityVU = nArray[3];
            int[] nArray2 = new int[]{capacityY, capacityVU};
            ByteBuffer[] byteBufferArray = BufferExtKt.slice(buffer, nArray2);
            ByteBuffer bufferY = byteBufferArray[0];
            ByteBuffer bufferVU = byteBufferArray[1];
            ByteBuffer byteBuffer = buffer.duplicate();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"buffer.duplicate()");
            return new Nv21Buffer(byteBuffer, bufferY, bufferVU, strideY, strideVU, width, height, releaseCallback, null);
        }

        public static /* synthetic */ Nv21Buffer wrap$default(Companion companion, ByteBuffer byteBuffer, int n, int n2, Runnable runnable, int n3, Object object) {
            if ((n3 & 8) != 0) {
                runnable = null;
            }
            return companion.wrap(byteBuffer, n, n2, runnable);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Nv21Buffer wrap(@NotNull ByteBuffer buffer, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            return io.github.crow_misia.libyuv.Nv21Buffer$Companion.wrap$default(this, buffer, width, height, null, 8, null);
        }

        private static final void allocate$lambda-0(ByteBuffer $buffer) {
            Intrinsics.checkNotNullParameter((Object)$buffer, (String)"$buffer");
            Yuv.INSTANCE.freeNativeBuffer($buffer);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

