/*
 * Decompiled with CFR 0.152.
 */
package com.bw.jtools.profiling;

import com.bw.jtools.profiling.ClassProfilingInformation;
import java.lang.reflect.Method;

public final class ReflectionProfilingUtil {
    private static StackAccessMode stackAccessMode = StackAccessMode.AUTO;
    private static Method throwableGetStackTraceElement;
    public static int CALLING_METHOD_STACK_INDEX;

    public static void setStackTraceAccessMode(StackAccessMode mode) {
        if (mode == StackAccessMode.AUTO) {
            try {
                Class.forName("java.lang.StackWalker");
                stackAccessMode = StackAccessMode.STACKWALKER;
            }
            catch (Exception t) {
                try {
                    throwableGetStackTraceElement = Throwable.class.getDeclaredMethod("getStackTraceElement", Integer.TYPE);
                    throwableGetStackTraceElement.setAccessible(true);
                    stackAccessMode = StackAccessMode.GETSTACKTRACEELEMENT;
                }
                catch (Exception e) {
                    stackAccessMode = StackAccessMode.FAILSAFE;
                }
            }
        } else {
            stackAccessMode = mode;
        }
    }

    public static StackAccessMode getStackTraceAccessMode() {
        return stackAccessMode;
    }

    public static StackTraceElement getStackTraceElement(int level) {
        if (stackAccessMode == StackAccessMode.STACKWALKER) {
            try {
                StackWalker.StackFrame result = StackWalker.getInstance().walk(stream -> stream.skip(level).limit(1L).findFirst().orElse(null));
                return result != null ? result.toStackTraceElement() : null;
            }
            catch (ArrayIndexOutOfBoundsException ai) {
                return null;
            }
            catch (Throwable t) {
                stackAccessMode = StackAccessMode.FAILSAFE;
            }
        } else if (stackAccessMode == StackAccessMode.GETSTACKTRACEELEMENT) {
            try {
                return (StackTraceElement)throwableGetStackTraceElement.invoke((Object)new Throwable(), level);
            }
            catch (Throwable t) {
                stackAccessMode = StackAccessMode.FAILSAFE;
            }
        }
        return new Throwable().getStackTrace()[level];
    }

    public static String normalizeClassName(String className) {
        if (className != null && ClassProfilingInformation.SIMPLE_NAMES) {
            int lastDot = className.lastIndexOf(46);
            if (lastDot >= 0) {
                return className.substring(lastDot + 1);
            }
            return className;
        }
        return className;
    }

    static {
        ReflectionProfilingUtil.setStackTraceAccessMode(StackAccessMode.AUTO);
        CALLING_METHOD_STACK_INDEX = 2;
    }

    public static enum StackAccessMode {
        STACKWALKER,
        GETSTACKTRACEELEMENT,
        FAILSAFE,
        AUTO;

    }
}

