/*
 * Decompiled with CFR 0.152.
 */
package com.bw.jtools.profiling;

import com.bw.jtools.profiling.MethodProfilingInformation;
import com.bw.jtools.profiling.ReflectionProfilingUtil;
import com.bw.jtools.profiling.ThreadProfilingInformation;
import com.bw.jtools.profiling.measurement.AbstractMeasurementSource;
import com.bw.jtools.profiling.measurement.MeasurementValue;

public final class MethodProfiling
implements AutoCloseable {
    public final MeasurementValue startTime = AbstractMeasurementSource.measure();
    protected MeasurementValue usedTime;
    protected final boolean notRecursive;
    public final MethodProfilingInformation method;

    public final MeasurementValue getUsedTime() {
        return this.usedTime;
    }

    public MethodProfiling() {
        StackTraceElement ste = ReflectionProfilingUtil.getStackTraceElement(ReflectionProfilingUtil.CALLING_METHOD_STACK_INDEX);
        this.method = ThreadProfilingInformation.getInstance().getClassInformation(ReflectionProfilingUtil.normalizeClassName(ste.getClassName())).getMethodInformation(ste.getMethodName());
        this.notRecursive = this.method.startCall();
    }

    public MethodProfiling(String clazz, String method) {
        ThreadProfilingInformation ti = ThreadProfilingInformation.getInstance();
        this.method = ti.getClassInformation(clazz).getMethodInformation(method);
        this.notRecursive = this.method.startCall();
    }

    public MethodProfiling(MethodProfilingInformation method) {
        this.method = method;
        this.notRecursive = this.method.startCall();
    }

    public void exception(Throwable t) {
        ++this.method.exceptions;
    }

    @Override
    public void close() {
        this.usedTime = AbstractMeasurementSource.measure();
        this.usedTime.subtract(this.startTime);
        this.method.endCall(this.usedTime, this.notRecursive);
    }
}

