/*
 * Decompiled with CFR 0.152.
 */
package com.bw.jtools.persistence;

import com.bw.jtools.persistence.MissingPropertyException;
import java.util.List;
import java.util.Properties;

public abstract class StorageBase {
    protected Properties defaults_;
    private boolean handleEmptyAsNull_ = false;

    protected StorageBase(Properties defaults) {
        this.defaults_ = defaults == null ? new Properties() : defaults;
    }

    public void setHandleEmptyAsNull(boolean emptyAsNull) {
        this.handleEmptyAsNull_ = emptyAsNull;
    }

    public Properties getDefaults() {
        return this.defaults_;
    }

    public final String getString(String key, String defaultVal) {
        String v = this.getString_impl(key);
        if (v != null && this.handleEmptyAsNull_ && v.isEmpty()) {
            v = null;
        }
        if (v == null) {
            v = this.defaults_.getProperty(key);
        }
        if (v == null) {
            return defaultVal;
        }
        return v;
    }

    public final String getString(String key) throws MissingPropertyException {
        String v = this.getString(key, null);
        if (v == null) {
            throw new MissingPropertyException(key);
        }
        return v;
    }

    public final double getDouble(String key, double def) {
        try {
            String val = this.getString(key, String.valueOf(def));
            return Double.parseDouble(val);
        }
        catch (Exception exception) {
            return def;
        }
    }

    public final void setDouble(String key, double value) {
        this.setString(key, String.valueOf(value));
    }

    public final int getInt(String key, int def) {
        try {
            String val = this.getString(key, String.valueOf(def));
            return Integer.parseInt(val);
        }
        catch (Exception exception) {
            return def;
        }
    }

    public final void setInt(String key, int value) {
        this.setString(key, String.valueOf(value));
    }

    public final boolean getBoolean(String key, boolean def) {
        String val = this.getString(key, def ? "On" : "Off");
        return val.equalsIgnoreCase("On") || val.equalsIgnoreCase("Yes") || val.equalsIgnoreCase("True");
    }

    public final void setBoolean(String key, boolean value) {
        this.setString(key, value ? "On" : "Off");
    }

    protected abstract String getString_impl(String var1);

    public abstract void setString(String var1, String var2);

    public abstract void deleteKey(String var1);

    public abstract void flush();

    public abstract void clear();

    public abstract List<String> getKeysWithPrefix(String var1);
}

