/*
 * Decompiled with CFR 0.152.
 */
package com.bw.jtools.persistence;

import com.bw.jtools.persistence.StorageBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

class PreferencesStorage
extends StorageBase {
    public static String PREF_ROOT_KEY = "bweng";

    public PreferencesStorage(Properties defaults) {
        super(defaults);
    }

    public static String[] getAllKeys() {
        try {
            return Preferences.userRoot().node(PREF_ROOT_KEY).keys();
        }
        catch (BackingStoreException ex) {
            return new String[0];
        }
    }

    @Override
    protected String getString_impl(String key) {
        return Preferences.userRoot().node(PREF_ROOT_KEY).get(key, null);
    }

    @Override
    public void setString(String key, String value) {
        Preferences.userRoot().node(PREF_ROOT_KEY).put(key, value);
    }

    @Override
    public void deleteKey(String key) {
        Preferences.userRoot().node(PREF_ROOT_KEY).remove(key);
    }

    @Override
    public void flush() {
        try {
            if (Preferences.userRoot().nodeExists(PREF_ROOT_KEY)) {
                Preferences.userRoot().node(PREF_ROOT_KEY).flush();
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void clear() {
        try {
            Preferences.userRoot().node(PREF_ROOT_KEY).removeNode();
            Preferences.userRoot().flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    @Override
    public List<String> getKeysWithPrefix(String prefix) {
        String[] all;
        ArrayList<String> l = new ArrayList<String>();
        for (String k : all = PreferencesStorage.getAllKeys()) {
            if (!k.startsWith(prefix)) continue;
            l.add(k);
        }
        return l;
    }
}

