/*
 * Decompiled with CFR 0.152.
 */
package com.bw.jtools.log;

import com.bw.jtools.Log;
import java.util.ArrayList;
import java.util.List;

public class MulticastLogger
extends Log.LoggerFacade {
    List<Log.LoggerFacade> logger_ = new ArrayList<Log.LoggerFacade>();

    @Override
    public synchronized void setLevel(int level) {
        for (Log.LoggerFacade log : this.logger_) {
            log.setLevel(level);
        }
        super.setLevel(level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Log.LoggerFacade addLogger(Log.LoggerFacade loggerVariable, Log.LoggerFacade newLog) {
        MulticastLogger ml;
        if (newLog == null) {
            return loggerVariable;
        }
        if (loggerVariable instanceof MulticastLogger) {
            ml = (MulticastLogger)loggerVariable;
        } else if (newLog instanceof MulticastLogger) {
            ml = (MulticastLogger)newLog;
            newLog = loggerVariable;
        } else if (loggerVariable != null) {
            ml = new MulticastLogger();
            ml.logger_.add(loggerVariable);
        } else {
            return newLog;
        }
        MulticastLogger multicastLogger = ml;
        synchronized (multicastLogger) {
            ml.logger_.remove(newLog);
            ml.logger_.add(newLog);
            ml.calcLevel();
        }
        return ml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Log.LoggerFacade removeLogger(Log.LoggerFacade loggerVariable, Log.LoggerFacade toRemove) {
        if (loggerVariable instanceof MulticastLogger) {
            MulticastLogger ml;
            MulticastLogger multicastLogger = ml = (MulticastLogger)loggerVariable;
            synchronized (multicastLogger) {
                ml.logger_.remove(toRemove);
                if (ml.logger_.size() == 1) {
                    Log.LoggerFacade log = ml.logger_.get(0);
                    ml.logger_.clear();
                    return log;
                }
                if (ml.logger_.isEmpty()) {
                    return null;
                }
                ml.calcLevel();
            }
        }
        if (loggerVariable == toRemove) {
            return null;
        }
        return loggerVariable;
    }

    protected void calcLevel() {
        int maxLevel = -1;
        for (Log.LoggerFacade log : this.logger_) {
            if (maxLevel >= log.getLevel()) continue;
            maxLevel = log.getLevel();
        }
        if (maxLevel >= 0) {
            this.setLevel(maxLevel);
        }
    }

    @Override
    public synchronized void error(CharSequence msg) {
        for (Log.LoggerFacade log : this.logger_) {
            log.error(msg);
        }
    }

    @Override
    public synchronized void warn(CharSequence msg) {
        for (Log.LoggerFacade log : this.logger_) {
            log.warn(msg);
        }
    }

    @Override
    public synchronized void info(CharSequence msg) {
        for (Log.LoggerFacade log : this.logger_) {
            log.info(msg);
        }
    }

    @Override
    public synchronized void debug(CharSequence msg) {
        for (Log.LoggerFacade log : this.logger_) {
            log.debug(msg);
        }
    }
}

