/*
 * Decompiled with CFR 0.152.
 */
package com.bw.jtools.log;

import com.bw.jtools.Log;
import com.bw.jtools.log.CollectorThreadLogger;
import java.util.HashMap;

public class CollectorLogger
extends Log.LoggerFacade {
    public HashMap<Long, CollectorThreadLogger> threadLogger = new HashMap(10);

    protected synchronized void addMessage(int level, CharSequence msg, Throwable t) {
        CollectorThreadLogger tLogger;
        if (this.level >= level && (tLogger = this.threadLogger.get(Thread.currentThread().getId())) != null && tLogger.level >= level) {
            String prefix = Log.LoggerFacade.getLevelPrefix(level);
            tLogger.messages.add(prefix + " " + msg);
            if (t != null && tLogger.maxTraceLines > 0) {
                tLogger.messages.add(prefix + " " + Log.getRestrictedStackTrace(t, " ", tLogger.maxTraceLines));
            }
        }
    }

    public synchronized CollectorThreadLogger getThreadLog() {
        return this.threadLogger.get(Thread.currentThread().getId());
    }

    public synchronized boolean hasThreadLog() {
        return !this.threadLogger.isEmpty();
    }

    public synchronized void setThreadLog(CollectorThreadLogger tlog) {
        long tid = Thread.currentThread().getId();
        if (tlog == null) {
            this.threadLogger.remove(tid);
        } else {
            this.threadLogger.put(tid, tlog);
        }
        int maxLevel = 0;
        for (CollectorThreadLogger tLogger : this.threadLogger.values()) {
            if (maxLevel >= tLogger.level) continue;
            maxLevel = tLogger.level;
        }
        this.setLevel(maxLevel);
    }

    @Override
    public void error(CharSequence msg) {
        this.addMessage(1, msg, null);
    }

    @Override
    public void warn(CharSequence msg) {
        this.addMessage(2, msg, null);
    }

    @Override
    public void info(CharSequence msg) {
        this.addMessage(3, msg, null);
    }

    @Override
    public void debug(CharSequence msg) {
        this.addMessage(4, msg, null);
    }

    @Override
    public void error(CharSequence msg, Throwable t) {
        this.addMessage(1, msg, t);
    }

    @Override
    public void warn(CharSequence msg, Throwable t) {
        this.addMessage(2, msg, t);
    }

    @Override
    public void debug(CharSequence msg, Throwable t) {
        this.addMessage(4, msg, t);
    }

    @Override
    public void info(CharSequence msg, Throwable t) {
        this.addMessage(3, msg, t);
    }
}

