/*
 * Decompiled with CFR 0.152.
 */
package com.bw.jtools.io;

import com.bw.jtools.Log;
import com.bw.jtools.ui.UITool;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public final class Tail {
    private static Thread pollThread = null;
    private static final List<StreamInfo> streams = new ArrayList<StreamInfo>();

    static void fireData(StreamInfo s) {
        UITool.executeInUIThread(() -> {
            StreamInfo streamInfo = s;
            synchronized (streamInfo) {
                while (s.getAvail() >= s.min) {
                    int amount = Math.min(s.max, s.getAvail());
                    for (TailListener l : s.listener) {
                        try {
                            l.read(s.buffer, s.getOffset(), amount);
                        }
                        catch (Exception e) {
                            Log.error("TailListener failed: " + e.getMessage(), e);
                        }
                    }
                    s.consume(amount);
                }
            }
        });
    }

    static void fireException(StreamInfo s, Throwable payload) {
        UITool.executeInUIThread(() -> {
            StreamInfo streamInfo = s;
            synchronized (streamInfo) {
                for (TailListener l : s.listener) {
                    l.exception(payload);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addStream(InputStream inputstream, TailListener t, int minLimit, int maxLimit) {
        Objects.requireNonNull(inputstream, "InputStream must not be null");
        Objects.requireNonNull(t, "TailListener must not be null");
        StreamInfo s = null;
        Class<Tail> clazz = streams;
        synchronized (clazz) {
            for (StreamInfo si : streams) {
                if (si.stream != inputstream) continue;
                s = si;
                break;
            }
            if (s == null) {
                StreamInfo ns = new StreamInfo(inputstream, minLimit, maxLimit);
                ns.listener.add(t);
                streams.add(ns);
            }
        }
        if (s != null) {
            clazz = s;
            synchronized (clazz) {
                s.listener.add(t);
                s.adaptLimits(minLimit, maxLimit);
            }
        }
        clazz = Tail.class;
        synchronized (Tail.class) {
            if (pollThread == null) {
                pollThread = new Thread(() -> {
                    boolean run = true;
                    do {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        List<StreamInfo> list = streams;
                        // MONITORENTER : list
                        if (streams.isEmpty()) {
                            run = false;
                        } else {
                            ArrayList<StreamInfo> localstreams = new ArrayList<StreamInfo>(streams.size());
                            localstreams.addAll(streams);
                        }
                        // MONITOREXIT : list
                        if (run) {
                            list = streams.iterator();
                        } else {
                            list = streams;
                            // MONITORENTER : list
                            boolean bl = run = !streams.isEmpty();
                            if (!run) {
                                Class<Tail> clazz = Tail.class;
                                // MONITORENTER : com.bw.jtools.io.Tail.class
                                pollThread = null;
                                // MONITOREXIT : clazz
                            }
                            // MONITOREXIT : list
                            continue;
                        }
                        while (list.hasNext()) {
                            StreamInfo is = (StreamInfo)list.next();
                            try {
                                int amount;
                                int av = is.stream.available();
                                if (is.getAvail() + av < is.min || (amount = Math.min(av, is.buffer.length - is.end)) < is.min && is.getAvail() >= is.min) continue;
                                is.stream.read(is.buffer, is.end, amount);
                                is.end += amount;
                                Tail.fireData(is);
                            }
                            catch (Exception e) {
                                Tail.fireException(is, e);
                            }
                        }
                    } while (run);
                });
                pollThread.start();
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeStream(InputStream inputstream, TailListener t) {
        List<StreamInfo> list = streams;
        synchronized (list) {
            Iterator<StreamInfo> sit = streams.iterator();
            while (sit.hasNext()) {
                StreamInfo si = sit.next();
                if (inputstream != null && si.stream != inputstream || t != null && !si.listener.contains(t)) continue;
                if (t != null) {
                    si.listener.remove(t);
                } else {
                    si.listener.clear();
                }
                if (!si.listener.isEmpty()) continue;
                sit.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop() {
        List<StreamInfo> list = streams;
        synchronized (list) {
            for (StreamInfo si : streams) {
                try {
                    si.stream.close();
                    si.listener.clear();
                }
                catch (Exception exception) {}
            }
            streams.clear();
        }
        Thread t = pollThread;
        if (t != null) {
            try {
                t.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class StreamInfo {
        InputStream stream;
        List<TailListener> listener = new ArrayList<TailListener>();
        byte[] buffer = new byte[10240];
        int min;
        int max;
        int start;
        int end;

        StreamInfo(InputStream stream, int min, int max) {
            this.stream = stream;
            this.min = min < 100 ? 100 : (min > 512 ? 512 : min);
            this.max = max < 512 ? 512 : max;
            this.start = 0;
            this.end = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void adaptLimits(int min, int max) {
            min = min < 100 ? 100 : (min > 512 ? 512 : min);
            int n = max = max < 512 ? 512 : max;
            if (min > max) {
                min = max;
            }
            StreamInfo streamInfo = this;
            synchronized (streamInfo) {
                if (min < this.min) {
                    int avail = this.getAvail();
                    if (avail >= min) {
                        this.end = this.start + min;
                        Tail.fireData(this);
                        this.end += avail - min;
                    }
                    this.min = min;
                }
                this.max = max;
            }
        }

        int getOffset() {
            return this.start;
        }

        int getAvail() {
            return this.end - this.start;
        }

        boolean isEmpty() {
            return this.start == this.end;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void consume(int amount) {
            StreamInfo streamInfo = this;
            synchronized (streamInfo) {
                this.start += amount;
                if (this.start >= this.end) {
                    this.start = 0;
                    this.end = 0;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void ensureFree(int amount) {
            StreamInfo streamInfo = this;
            synchronized (streamInfo) {
                int avail = this.getAvail();
                if (avail > 0) {
                    if (this.buffer.length - avail < amount) {
                        byte[] newBuffer = this.createBuffer(avail + amount);
                        System.arraycopy(this.buffer, this.start, newBuffer, 0, avail);
                        this.buffer = newBuffer;
                        this.start = 0;
                        this.end = avail;
                    } else if (this.buffer.length - this.end < amount) {
                        System.arraycopy(this.buffer, this.start, this.buffer, 0, avail);
                        this.start = 0;
                        this.end = avail;
                    }
                } else if (this.buffer.length < amount) {
                    this.buffer = this.createBuffer(amount);
                    this.start = 0;
                    this.end = 0;
                }
            }
        }

        private byte[] createBuffer(int neededSpace) {
            return new byte[10240 * ((neededSpace + 10239) / 10240)];
        }
    }

    public static interface TailListener {
        public void read(byte[] var1, int var2, int var3);

        public void exception(Throwable var1);
    }
}

