/*
 * Decompiled with CFR 0.152.
 */
package com.bw.jtools.io;

import com.bw.jtools.Log;
import com.bw.jtools.io.DirectoryMonitorListener;
import com.bw.jtools.persistence.Store;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class DirectoryMonitor {
    protected FileSystem fileSystem;
    protected final ConcurrentHashMap<String, PathData> paths = new ConcurrentHashMap();
    protected final ConcurrentHashMap<WatchKey, PathData> watchServiceKeys = new ConcurrentHashMap();
    public static final String KEY_POLL_TIME_MS = "filemonitor.pollTimeMS";
    public static final String KEY_POLL_PATH_PREFIX = "filemonitor.pathToPoll.";
    private static final ArrayList<String> pathsToPoll = new ArrayList();
    private static boolean pathsToPoll_Read = false;
    private static int pollTimeOutMS = 1000;
    protected Thread watchThread = null;
    protected Thread pollThread = null;
    protected WatchService watchService = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean needsPolling(Path path_searched) {
        if (!pathsToPoll_Read) {
            ArrayList<String> arrayList = pathsToPoll;
            synchronized (arrayList) {
                if (!pathsToPoll_Read) {
                    pollTimeOutMS = Store.getInt(KEY_POLL_TIME_MS, 1000);
                    List<String> keys = Store.getKeysWithPrefix(KEY_POLL_PATH_PREFIX);
                    pathsToPoll.clear();
                    pathsToPoll.ensureCapacity(keys.size());
                    for (String pkey : keys) {
                        String pval = Store.getString(pkey, null);
                        if (pval == null || pval.isEmpty()) continue;
                        try {
                            pval = new File(pval).getCanonicalPath();
                        }
                        catch (Exception ex) {
                            Log.warn(pkey + "=" + pval + ": failed to create canonical path. Using un-checked specified value.", ex);
                        }
                        pathsToPoll.add(pval);
                    }
                    pathsToPoll_Read = true;
                }
            }
        }
        String path_name = path_searched.toFile().getPath();
        for (String p : pathsToPoll) {
            if (!path_name.startsWith(p)) continue;
            return true;
        }
        return false;
    }

    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PathData getPathData(Path path) {
        try {
            File file = path.toFile();
            ConcurrentHashMap<String, PathData> concurrentHashMap = this.paths;
            synchronized (concurrentHashMap) {
                return this.paths.get(file.getCanonicalFile().getPath());
            }
        }
        catch (Exception ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PathData addPath(Path path, boolean handleInitialFoundFiles) throws IOException {
        File file = path.toFile();
        if (!file.isDirectory()) {
            throw new IOException("DirectoryMonitor:'" + path + "' is not a directoy.");
        }
        try {
            file = file.getCanonicalFile();
            path = file.toPath();
        }
        catch (Exception ex) {
            Log.warn("DirectoryMonitor:'" + path + "' - failed to create canonical path. Using un-checked specified value.", ex);
        }
        boolean poll = DirectoryMonitor.needsPolling(path);
        ConcurrentHashMap<String, PathData> concurrentHashMap = this.paths;
        synchronized (concurrentHashMap) {
            PathData pd = new PathData(path, handleInitialFoundFiles);
            pd.poll = poll;
            this.paths.put(file.getPath(), pd);
            if (poll || handleInitialFoundFiles) {
                if (poll) {
                    Log.info("DirectoryMonitor: Polling for " + path);
                }
                if (this.pollThread == null) {
                    this.pollThread = new Thread(() -> this.pollForChanges(), "DmPoll");
                    this.pollThread.start();
                }
            }
            if (!poll) {
                FileSystem fs = path.getFileSystem();
                if (this.fileSystem == null) {
                    this.fileSystem = fs;
                    this.watchService = this.fileSystem.newWatchService();
                } else if (fs != this.fileSystem) {
                    Log.warn("DirectoryMonitor:" + path + " - Try to handle different file-systems by one instance, this may fail.");
                }
                WatchKey key = path.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                Log.info("DirectoryMonitor: Watching " + path);
                this.watchServiceKeys.put(key, pd);
                if (this.watchThread == null) {
                    this.watchThread = new Thread(() -> this.handleWatchServiceEvents(), "DmWatch");
                    this.watchThread.start();
                }
            }
            return pd;
        }
    }

    public synchronized Path addPath(Path path, boolean handleInitialFoundFiles, DirectoryMonitorListener l) throws IOException {
        PathData pd = this.getPathData(path);
        if (pd == null) {
            pd = this.addPath(path, handleInitialFoundFiles);
        }
        if (pd != null) {
            pd.listener.remove(l);
            if (l != null) {
                pd.listener.add(l);
            }
            return pd.path;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void removePath(Path path, DirectoryMonitorListener listener) {
        File file = path.toFile();
        ConcurrentHashMap<String, PathData> concurrentHashMap = this.paths;
        synchronized (concurrentHashMap) {
            try {
                String cannonialPath = file.getCanonicalFile().getPath();
                PathData pd = this.paths.get(cannonialPath);
                if (pd == null) return;
                pd.listener.remove(listener);
                if (!pd.listener.isEmpty()) return;
                this.paths.remove(cannonialPath);
                if (!pd.poll) return;
            }
            catch (Exception exception) {
                // empty catch block
            }
            {
                // empty if block
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pollForChanges() {
        ArrayList<PathData> path2Poll = new ArrayList<PathData>();
        while (true) {
            try {
                Thread.sleep(pollTimeOutMS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ConcurrentHashMap<String, PathData> concurrentHashMap = this.paths;
            synchronized (concurrentHashMap) {
                for (PathData pd : this.paths.values()) {
                    if (!pd.poll && !pd.handleInitialFiles) continue;
                    path2Poll.add(pd);
                }
            }
            for (PathData pd : path2Poll) {
                pd.pollChanges();
                pd.notifyListener(this);
            }
            path2Poll.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleWatchServiceEvents() {
        PathData pd;
        WatchKey key;
        while (true) {
            boolean overflowOccured = false;
            try {
                key = this.watchService.take();
            }
            catch (InterruptedException x) {
                Log.error("DirectoryMonitor: WatchService interrupted.");
                return;
            }
            pd = this.watchServiceKeys.get(key);
            if (pd == null) {
                Log.warn("DirectoryMonitor: Unknown key reported: " + key.watchable());
                key.cancel();
            } else {
                List<WatchEvent<?>> events = key.pollEvents();
                for (WatchEvent<?> event : events) {
                    WatchEvent.Kind<?> kind = event.kind();
                    if (kind == StandardWatchEventKinds.OVERFLOW) {
                        overflowOccured = true;
                        continue;
                    }
                    WatchEvent<?> ev = event;
                    Path filename = (Path)ev.context();
                    if (filename == null) continue;
                    try {
                        DirectoryMonitor directoryMonitor = this;
                        synchronized (directoryMonitor) {
                            String name = filename.toFile().getName();
                            Path path = pd.path.resolve(filename);
                            File file = path.toFile();
                            if (file.exists()) {
                                Long lastMod = (Long)pd.poll_CurrentState.get(name);
                                long newMod = file.lastModified();
                                if (lastMod == null || lastMod != newMod) {
                                    PathData pathData = pd;
                                    synchronized (pathData) {
                                        pd.poll_CurrentState.put(name, newMod);
                                        if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                                            pd.changes.add(new ChangeData(path, ChangeMode.CREATED));
                                        } else if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                                            pd.changes.add(new ChangeData(path, ChangeMode.REMOVED));
                                        } else if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                                            pd.changes.add(new ChangeData(path, ChangeMode.CHANGED));
                                        }
                                    }
                                }
                                continue;
                            }
                            PathData pathData = pd;
                            synchronized (pathData) {
                                pd.poll_CurrentState.remove(name);
                                if (kind != StandardWatchEventKinds.ENTRY_DELETE) {
                                    continue;
                                }
                                pd.changes.add(new ChangeData(path, ChangeMode.REMOVED));
                            }
                        }
                        pd.notifyListener(this);
                    }
                    catch (Exception exception) {}
                }
            }
            if (!key.reset()) break;
            if (!overflowOccured) continue;
            Log.error("DirectoryMonitor: Event Overflow for " + pd.path.toString());
        }
        Log.error("DirectoryMonitor: Directory lost: " + pd.path.toString());
        key.cancel();
    }

    protected static final class PathData {
        public Vector<ChangeData> changes = new Vector(10);
        public boolean error_state = false;
        public boolean poll = false;
        private boolean handleInitialFiles = false;
        private boolean firstScan = true;
        private final Path path;
        private HashMap<String, Long> poll_CurrentState = new HashMap();
        private HashMap<String, Long> poll_next = new HashMap();
        private final List<DirectoryMonitorListener> listener = new ArrayList<DirectoryMonitorListener>();

        public PathData(Path path, boolean handleInitialFoundFiles) {
            this.path = path;
            this.handleInitialFiles = handleInitialFoundFiles;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pollChanges() {
            block11: {
                try {
                    long[] lmods;
                    File[] files = this.path.toFile().listFiles();
                    if (files != null) {
                        lmods = new long[files.length];
                        for (int i = 0; i < files.length; ++i) {
                            lmods[i] = files[i].lastModified();
                        }
                    } else {
                        files = new File[]{};
                        lmods = new long[]{};
                    }
                    PathData pathData = this;
                    synchronized (pathData) {
                        this.poll_next.clear();
                        for (int i = 0; i < files.length; ++i) {
                            File f = files[i];
                            long lmod = lmods[i];
                            String name = f.getName();
                            if (lmod == 0L) continue;
                            Long lastMod = this.poll_CurrentState.remove(name);
                            this.poll_next.put(name, lmod);
                            if (lastMod != null) {
                                if (lastMod == lmod) continue;
                                this.changes.add(new ChangeData(this.path.resolve(name), ChangeMode.CHANGED));
                                continue;
                            }
                            this.changes.add(new ChangeData(this.path.resolve(name), this.firstScan ? ChangeMode.INITIAL : ChangeMode.CREATED));
                        }
                        for (String name : this.poll_CurrentState.keySet()) {
                            this.changes.add(new ChangeData(this.path.resolve(name), ChangeMode.REMOVED));
                        }
                        HashMap<String, Long> tmp = this.poll_CurrentState;
                        this.poll_CurrentState = this.poll_next;
                        this.poll_next = tmp;
                    }
                    this.handleInitialFiles = false;
                    this.firstScan = false;
                    this.error_state = false;
                }
                catch (Exception e) {
                    if (this.error_state) break block11;
                    this.error_state = true;
                    Log.error(this.path.toFile().getPath() + ": " + e.getMessage(), e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void notifyListener(DirectoryMonitor dm) {
            Vector<ChangeData> changes_switch;
            PathData pathData = this;
            synchronized (pathData) {
                changes_switch = this.changes;
                this.changes = new Vector();
            }
            for (ChangeData cd : changes_switch) {
                for (DirectoryMonitorListener l : this.listener) {
                    if (cd.kind == ChangeMode.CHANGED) {
                        l.fileChanged(dm, cd.path);
                        continue;
                    }
                    if (cd.kind == ChangeMode.CREATED) {
                        l.fileAdded(dm, cd.path);
                        continue;
                    }
                    if (cd.kind == ChangeMode.REMOVED) {
                        l.fileRemoved(dm, cd.path);
                        continue;
                    }
                    if (cd.kind != ChangeMode.INITIAL) continue;
                    l.fileInitialAdded(dm, cd.path);
                }
            }
            changes_switch.clear();
        }
    }

    public static enum ChangeMode {
        CREATED,
        REMOVED,
        CHANGED,
        INITIAL;

    }

    public static final class ChangeData {
        public final Path path;
        public final ChangeMode kind;

        private ChangeData(Path path, ChangeMode kind) {
            this.path = path;
            this.kind = kind;
        }
    }
}

