/*
 * Decompiled with CFR 0.152.
 */
package com.bw.jtools.collections;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public final class IdMap<E>
extends AbstractCollection<E> {
    int size;
    int threshold;
    final float loadFactor;
    IdEntry<E>[] table;

    public IdMap() {
        this(16, 0.75f);
    }

    public IdMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IdMap(int initialCapacity, float loadFactor) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new IdEntry[capacity];
        this.size = 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new IdMapIterator();
    }

    public E put(int id, E value) {
        int index = this.indexForId(id);
        IdEntry<E> e = this.table[index];
        while (e != null) {
            if (e.id == id) {
                Object oldValue = e.value;
                e.value = value;
                return oldValue;
            }
            e = e.next;
        }
        this.table[index] = new IdEntry<E>(id, value, this.table[index]);
        ++this.size;
        if (this.size > this.threshold) {
            this.resize(2 * this.table.length);
        }
        return null;
    }

    public E removeKey(int id) {
        int index = this.indexForId(id);
        IdEntry<E> e = this.table[index];
        if (e != null) {
            if (e.id == id) {
                this.table[index] = e.next;
                --this.size;
                return e.value;
            }
            IdEntry<E> prev = e;
            e = e.next;
            while (e != null) {
                if (e.id == id) {
                    prev.next = e.next;
                    --this.size;
                    return e.value;
                }
                prev = e;
                e = e.next;
            }
        }
        return null;
    }

    public E get(int id) {
        int index = this.indexForId(id);
        IdEntry<E> e = this.table[index];
        while (e != null) {
            if (e.id == id) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    public boolean containsId(int id) {
        return this.get(id) != null;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        int N = this.table.length;
        this.size = 0;
        for (int i = 0; i < N; ++i) {
            this.table[i] = null;
        }
    }

    protected final int indexForId(int key) {
        return key & this.table.length - 1;
    }

    protected final void resize(int newCapacity) {
        int oldLength = this.table.length;
        IdEntry<E>[] oldTable = this.table;
        this.table = new IdEntry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        for (int i = 0; i < oldLength; ++i) {
            IdEntry<E> e = oldTable[i];
            while (e != null) {
                IdEntry next = e.next;
                int newIndex = this.indexForId(e.id);
                e.next = this.table[newIndex];
                this.table[newIndex] = e;
                e = next;
            }
        }
    }

    public final List<E> toList() {
        ArrayList<E> list = new ArrayList<E>(this.size);
        for (E v : this) {
            list.add(v);
        }
        return list;
    }

    private final class IdMapIterator
    implements Iterator<E> {
        IdEntry<E> next;
        int bucket = 0;
        IdEntry<E> current = null;

        IdMapIterator() {
            while (this.bucket < IdMap.this.table.length && IdMap.this.table[this.bucket] == null) {
                ++this.bucket;
            }
            this.next = this.bucket < IdMap.this.table.length ? IdMap.this.table[this.bucket] : null;
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        final IdEntry<E> nextEntry() {
            this.current = this.next;
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            this.next = this.current.next;
            if (this.next == null) {
                ++this.bucket;
                while (this.bucket < IdMap.this.table.length && IdMap.this.table[this.bucket] == null) {
                    ++this.bucket;
                }
                this.next = this.bucket < IdMap.this.table.length ? IdMap.this.table[this.bucket] : null;
            }
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            int k = this.current.id;
            this.current = null;
            IdMap.this.removeKey(k);
        }

        @Override
        public E next() {
            return this.nextEntry().value;
        }
    }

    protected static final class IdEntry<E> {
        final int id;
        E value;
        IdEntry<E> next;

        IdEntry(int id_, E value_, IdEntry<E> next_) {
            this.id = id_;
            this.value = value_;
            this.next = next_;
        }

        public final String toString() {
            return this.id + "=" + this.value;
        }
    }
}

