/*
 * Decompiled with CFR 0.152.
 */
package com.bw.jtools.profiling.weaving;

import com.bw.jtools.Log;
import com.bw.jtools.profiling.weaving.ByteBuddyProfilingCtorAdvice;
import com.bw.jtools.profiling.weaving.ByteBuddyProfilingThrowAdvice;
import java.io.InputStreamReader;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class ProfilingWeaver {
    public static final String ARG_REGEX = "regex";
    public static final String ARG_VERBOSE = "verbose";
    public static final String CODE_SOURCE = "$CODESOURCE";
    public static final String PROP_PREFIX = "profiling.weaver.";
    public static final String PROP_PROPERTY_FILE = "profiling.weaver.ini";

    /*
     * WARNING - void declaration
     */
    public static void premain(String agentArgument, Instrumentation instrumentation) {
        String regExp;
        boolean verbose;
        HashMap<String, String> args = new HashMap<String, String>();
        args.put(ARG_VERBOSE, "false");
        String val = System.getProperty("profiling.weaver.regex");
        if (val != null) {
            args.put(ARG_REGEX, val);
        }
        String argPropertyFile = System.getProperty(PROP_PROPERTY_FILE);
        val = System.getProperty("profiling.weaver.verbose");
        if (val != null) {
            args.put(ARG_VERBOSE, val);
        }
        if (agentArgument != null) {
            argPropertyFile = agentArgument;
        }
        if (argPropertyFile != null) {
            try {
                int csIndex = argPropertyFile.indexOf(CODE_SOURCE);
                if (csIndex >= 0) {
                    URL codeURL;
                    try {
                        void var7_9;
                        codeURL = ProfilingWeaver.class.getProtectionDomain().getCodeSource().getLocation();
                        Path path = Paths.get(codeURL.toURI());
                        while (Files.isRegularFile((Path)var7_9, new LinkOption[0])) {
                            Path path2 = var7_9.getParent();
                        }
                        codeURL = var7_9.toUri().toURL();
                    }
                    catch (Exception exception) {
                        Log.error("Failed to access code source location.", exception);
                        codeURL = new URL(".");
                    }
                    argPropertyFile = argPropertyFile.substring(0, csIndex) + codeURL.toURI().getPath() + argPropertyFile.substring(csIndex + CODE_SOURCE.length());
                }
                URL uri = new URL(argPropertyFile);
                Properties properties = new Properties();
                properties.load(new InputStreamReader(uri.openStream()));
                for (Map.Entry<Object, Object> v : properties.entrySet()) {
                    args.put((String)v.getKey(), (String)v.getValue());
                }
            }
            catch (Exception e) {
                Log.error("Failed to access property file '" + argPropertyFile + "'", e);
            }
        }
        if ((verbose = Boolean.valueOf((String)args.get(ARG_VERBOSE)).booleanValue()) && !args.isEmpty()) {
            Log.info("Arguments:");
            for (Map.Entry entry : args.entrySet()) {
                Log.info("\t" + (String)entry.getKey() + " = " + (String)entry.getValue());
            }
        }
        if ((regExp = (String)args.get(ARG_REGEX)) != null && !regExp.isEmpty()) {
            void var7_19;
            String[] matchRegExp;
            AgentBuilder.Default default_ = new AgentBuilder.Default();
            if (verbose) {
                AgentBuilder agentBuilder = default_.with(AgentBuilder.Listener.StreamWriting.toSystemOut());
            }
            for (String reg : matchRegExp = regExp.split("[\\s;]+")) {
                if (reg.isEmpty()) continue;
                String[] regExpSpec = regExp.split("(?<!\\\\):");
                if (regExpSpec == null || regExpSpec.length < 2 || regExpSpec.length > 3) {
                    Log.error("Illegal matcher expression: " + reg);
                    continue;
                }
                String classRegExp = regExpSpec[0];
                String methodRegExp = regExpSpec[1];
                String flags = regExpSpec.length > 2 ? regExpSpec[2].toUpperCase() : "";
                boolean profileCtors = flags.indexOf("+C") >= 0;
                boolean profileInitializers = flags.indexOf("+I") >= 0;
                boolean profilePrivate = flags.indexOf("-V") < 0;
                boolean profileProtected = flags.indexOf("-T") < 0;
                boolean profilePublic = flags.indexOf("-B") < 0;
                boolean profilePackagePriv = flags.indexOf("-K") < 0;
                AgentBuilder.Identified.Extendable extendable = var7_19.type(ElementMatchers.nameMatches(classRegExp)).transform((builder, typeDescription, classLoader, module) -> {
                    if (verbose) {
                        Log.info("Weaving methods of " + typeDescription.getName() + " matching " + methodRegExp);
                    }
                    ElementMatcher.Junction excludeMatch = ElementMatchers.isConstructor().or(ElementMatchers.isDefaultFinalizer()).or(ElementMatchers.isAbstract()).or(ElementMatchers.isNative()).or(ElementMatchers.isSynthetic());
                    if (!profilePublic) {
                        excludeMatch = excludeMatch.or(ElementMatchers.isPublic());
                    }
                    if (!profilePrivate) {
                        excludeMatch = excludeMatch.or(ElementMatchers.isPrivate());
                    }
                    if (!profileProtected) {
                        excludeMatch = excludeMatch.or(ElementMatchers.isProtected());
                    }
                    if (!profilePackagePriv) {
                        excludeMatch = excludeMatch.or(ElementMatchers.isPackagePrivate());
                    }
                    if (!profileInitializers) {
                        excludeMatch = excludeMatch.or(ElementMatchers.isTypeInitializer());
                    }
                    ElementMatcher.Junction matcher = ElementMatchers.nameMatches(methodRegExp).and(ElementMatchers.isDeclaredBy(typeDescription)).and(ElementMatchers.not(excludeMatch));
                    builder = builder.visit(Advice.to(ByteBuddyProfilingThrowAdvice.class).on(matcher));
                    if (profileCtors) {
                        ElementMatcher.Junction excludeCtorMatch = ElementMatchers.isNative().or(ElementMatchers.isSynthetic());
                        ElementMatcher.Junction ctormatcher = ElementMatchers.isConstructor().and(ElementMatchers.isDeclaredBy(typeDescription)).and(ElementMatchers.not(excludeCtorMatch));
                        builder = builder.visit(Advice.to(ByteBuddyProfilingCtorAdvice.class).on(ctormatcher));
                    }
                    return builder;
                });
            }
            var7_19.installOn(instrumentation);
        }
    }
}

