/*
 * Decompiled with CFR 0.152.
 */
package com.bw.jtools.profiling;

import com.bw.jtools.profiling.ClassProfilingInformation;
import com.bw.jtools.profiling.MethodProfilingInformation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class ThreadProfilingInformation {
    private final Map<String, ClassProfilingInformation> threadClassInfo = new HashMap<String, ClassProfilingInformation>(50);
    private static final ThreadLocalProfilingInformation INSTANCE = new ThreadLocalProfilingInformation();
    private List<MethodProfilingInformation> stack = new ArrayList<MethodProfilingInformation>(50);
    private HashSet<Integer> stackIds = new HashSet(50);

    private ThreadProfilingInformation() {
    }

    public static ThreadProfilingInformation getInstance() {
        return (ThreadProfilingInformation)INSTANCE.get();
    }

    public ClassProfilingInformation getClassInformation(Class<?> clazz) {
        return this.getClassInformation(ClassProfilingInformation.SIMPLE_NAMES ? clazz.getSimpleName() : clazz.getName());
    }

    public ClassProfilingInformation getClassInformation(String clazz) {
        ClassProfilingInformation ci = this.threadClassInfo.get(clazz);
        if (ci == null) {
            ci = ClassProfilingInformation.getClassInformation(clazz);
            this.threadClassInfo.put(clazz, ci);
        }
        return ci;
    }

    public MethodProfilingInformation getCurrentMethod() {
        return this.stack.isEmpty() ? null : this.stack.get(this.stack.size() - 1);
    }

    public boolean isOnStack(MethodProfilingInformation mi) {
        return this.stackIds.contains(mi.ID);
    }

    public void popMethod(MethodProfilingInformation mi) {
        int s = this.stack.size();
        if (mi != null) {
            while (s > 0) {
                MethodProfilingInformation smi = this.stack.remove(--s);
                this.stackIds.remove(smi.ID);
                if (mi != smi) continue;
                break;
            }
        } else if (s > 0) {
            MethodProfilingInformation smi = this.stack.remove(--s);
            this.stackIds.remove(smi.ID);
        }
    }

    public boolean pushMethod(MethodProfilingInformation mi) {
        if (this.stackIds.add(mi.ID)) {
            this.stack.add(mi);
            return true;
        }
        return false;
    }

    private static final class ThreadLocalProfilingInformation
    extends ThreadLocal<ThreadProfilingInformation> {
        private ThreadLocalProfilingInformation() {
        }

        @Override
        protected ThreadProfilingInformation initialValue() {
            return new ThreadProfilingInformation();
        }
    }
}

