/*
 * Decompiled with CFR 0.152.
 */
package com.bw.jtools.log;

import com.bw.jtools.Log;
import com.sun.management.UnixOperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadMXBean;

public final class OS {
    private static ThreadMXBean threadMXBean = null;

    public static long getOpenFileHandles() {
        OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
        if (os instanceof UnixOperatingSystemMXBean) {
            return ((UnixOperatingSystemMXBean)os).getOpenFileDescriptorCount();
        }
        return -1L;
    }

    public static long getMaxOpenFileHandles() {
        OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
        if (os instanceof UnixOperatingSystemMXBean) {
            return ((UnixOperatingSystemMXBean)os).getMaxFileDescriptorCount();
        }
        return -1L;
    }

    public static double getSystemLoadAverage() {
        OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
        return os.getSystemLoadAverage();
    }

    public static String getOSName() {
        return System.getProperty("os.name") + " v" + System.getProperty("os.version") + "/" + System.getProperty("os.arch");
    }

    public static long getThreadExecutionTimeNS() {
        if (threadMXBean != null) {
            return threadMXBean.getCurrentThreadCpuTime();
        }
        return System.nanoTime();
    }

    public static boolean isThreadTimeMeasurementUsed() {
        return threadMXBean != null;
    }

    public static void init() {
        ThreadMXBean mb = ManagementFactory.getThreadMXBean();
        try {
            if (mb.isCurrentThreadCpuTimeSupported()) {
                if (!mb.isThreadCpuTimeEnabled()) {
                    mb = null;
                    Log.warn("JVM's Thread-Cpu-Time-Measurement is disabled.");
                } else {
                    Log.info("JVM's Thread-Cpu-Time-Measurement is enabled.");
                }
            } else {
                Log.warn("JVM does't supports Thread-Cpu-Time-Measurement.");
                mb = null;
            }
        }
        catch (UnsupportedOperationException ignored) {
            Log.warn("JVM does't supports Thread-Cpu-Time-Measurement.", ignored);
            mb = null;
        }
        threadMXBean = mb;
    }

    public static class Info {
        public final long open_handles;
        public final long max_handles;
        public final double average_load;

        public Info() {
            OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
            if (os instanceof UnixOperatingSystemMXBean) {
                UnixOperatingSystemMXBean unix = (UnixOperatingSystemMXBean)os;
                this.open_handles = unix.getOpenFileDescriptorCount();
                this.max_handles = unix.getMaxFileDescriptorCount();
            } else {
                this.open_handles = -1L;
                this.max_handles = -1L;
            }
            this.average_load = os.getSystemLoadAverage();
        }
    }
}

