/*
 * Decompiled with CFR 0.152.
 */
package com.bw.jtools.log;

import com.bw.jtools.Log;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;

public class Log4JLogger
extends Log.LoggerFacade {
    public static Logger log4j = LogManager.getLogger(Log.class);

    protected int getCurrentLog4JLevel() {
        Level lv = log4j.getLevel();
        if (lv == Level.FATAL || lv == Level.FATAL) {
            return 1;
        }
        if (lv == Level.INFO) {
            return 3;
        }
        if (lv == Level.ALL || lv == Level.DEBUG || lv == Level.TRACE) {
            return 4;
        }
        if (lv == Level.WARN) {
            return 2;
        }
        return 0;
    }

    public Log4JLogger() {
        super.setLevel(this.getCurrentLog4JLevel());
    }

    @Override
    public void setLevel(int level) {
        Level lv;
        super.setLevel(level);
        switch (level) {
            case 0: {
                lv = Level.OFF;
                break;
            }
            case 1: {
                lv = Level.ERROR;
                break;
            }
            case 2: {
                lv = Level.WARN;
                break;
            }
            case 3: {
                lv = Level.INFO;
                break;
            }
            case 4: {
                lv = Level.DEBUG;
                break;
            }
            default: {
                lv = Level.WARN;
            }
        }
        Configurator.setRootLevel((Level)lv);
    }

    @Override
    public void error(CharSequence msg) {
        log4j.error(msg);
    }

    @Override
    public void warn(CharSequence msg) {
        log4j.warn(msg);
    }

    @Override
    public void info(CharSequence msg) {
        log4j.info(msg);
    }

    @Override
    public void debug(CharSequence msg) {
        log4j.debug(msg);
    }

    @Override
    public void error(CharSequence msg, Throwable t) {
        log4j.error(msg, t);
    }

    @Override
    public void warn(CharSequence msg, Throwable t) {
        log4j.warn(msg, t);
    }

    @Override
    public void info(CharSequence msg, Throwable t) {
        log4j.info(msg, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return log4j.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return log4j.isInfoEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return log4j.isWarnEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return log4j.isErrorEnabled();
    }
}

