/*
 * Decompiled with CFR 0.152.
 */
package kr.co.bootpay.android;

import android.app.Activity;
import android.content.Context;
import androidx.fragment.app.FragmentManager;
import kr.co.bootpay.android.api.BootpayDialog;
import kr.co.bootpay.android.api.BootpayDialogX;
import kr.co.bootpay.android.api.BootpayInterface;
import kr.co.bootpay.android.events.BootpayEventListener;
import kr.co.bootpay.android.models.Payload;

public class BootpayBuilder
implements BootpayInterface {
    private Activity mActivity;
    private android.app.FragmentManager mFragmentManager;
    private FragmentManager mFragmentManagerX;
    private Context mContext;
    private BootpayDialog mDialog;
    private BootpayDialogX mDialogX;
    private Payload mPayload;
    private BootpayEventListener mBootpayEventListener;

    public BootpayBuilder(Activity activity, Context context) {
        this.mActivity = activity;
        this.mFragmentManager = activity.getFragmentManager();
        this.mFragmentManagerX = null;
        this.mDialog = new BootpayDialog();
        this.mDialogX = null;
        this.mContext = context;
    }

    public BootpayBuilder(android.app.FragmentManager fragmentManager, Context context) {
        this.mActivity = null;
        this.mFragmentManager = fragmentManager;
        this.mFragmentManagerX = null;
        this.mDialog = new BootpayDialog();
        this.mDialogX = null;
        this.mContext = context;
    }

    public BootpayBuilder(FragmentManager fragmentManager, Context context) {
        this.mActivity = null;
        this.mFragmentManager = null;
        this.mFragmentManagerX = fragmentManager;
        this.mDialog = null;
        this.mDialogX = new BootpayDialogX();
        this.mContext = context;
    }

    private Object getHostUIComponent() {
        if (this.mActivity != null) {
            return this.mActivity;
        }
        if (this.mFragmentManager != null) {
            return this.mFragmentManager;
        }
        if (this.mFragmentManagerX != null) {
            return this.mFragmentManagerX;
        }
        throw new IllegalStateException("activity, fragment \uc911 \ud558\ub098\uc758 UI\uc5d0\uc11c \uc2e4\ud589\ub418\uc5b4\uc57c \ud569\ub2c8\ub2e4.");
    }

    public BootpayBuilder setPayload(Payload payload) {
        this.mPayload = payload;
        return this;
    }

    public BootpayBuilder setEventListener(BootpayEventListener listener) {
        this.mBootpayEventListener = listener;
        return this;
    }

    public void requestPayment() {
        if (this.mDialog != null) {
            if (this.mPayload != null) {
                this.mDialog.setPayload(this.mPayload);
            }
            if (this.mBootpayEventListener != null) {
                this.mDialog.setEventListener(this.mBootpayEventListener);
            }
            this.mDialog.requestPayment(this.mFragmentManager);
            return;
        }
        if (this.mDialogX != null) {
            if (this.mPayload != null) {
                this.mDialogX.setPayload(this.mPayload);
            }
            if (this.mBootpayEventListener != null) {
                this.mDialogX.setEventListener(this.mBootpayEventListener);
            }
            this.mDialogX.requestPayment(this.mFragmentManagerX);
            return;
        }
    }

    public void requestSubscription() {
        if (this.mDialog != null) {
            if (this.mPayload != null) {
                this.mDialog.setPayload(this.mPayload);
            }
            if (this.mBootpayEventListener != null) {
                this.mDialog.setEventListener(this.mBootpayEventListener);
            }
            this.mDialog.requestSubscription(this.mFragmentManager);
            return;
        }
        if (this.mDialogX != null) {
            if (this.mPayload != null) {
                this.mDialogX.setPayload(this.mPayload);
            }
            if (this.mBootpayEventListener != null) {
                this.mDialogX.setEventListener(this.mBootpayEventListener);
            }
            this.mDialogX.requestSubscription(this.mFragmentManagerX);
            return;
        }
    }

    public void requestAuthentication() {
        if (this.mDialog != null) {
            if (this.mPayload != null) {
                this.mDialog.setPayload(this.mPayload);
            }
            if (this.mBootpayEventListener != null) {
                this.mDialog.setEventListener(this.mBootpayEventListener);
            }
            this.mDialog.requestAuthentication(this.mFragmentManager);
            return;
        }
        if (this.mDialogX != null) {
            if (this.mPayload != null) {
                this.mDialogX.setPayload(this.mPayload);
            }
            if (this.mBootpayEventListener != null) {
                this.mDialogX.setEventListener(this.mBootpayEventListener);
            }
            this.mDialogX.requestAuthentication(this.mFragmentManagerX);
            return;
        }
    }

    public void transactionConfirm(String data) {
        if (this.mDialog != null) {
            this.mDialog.transactionConfirm(data);
        }
        if (this.mDialogX != null) {
            this.mDialogX.transactionConfirm(data);
        }
    }

    @Override
    public void removePaymentWindow() {
        if (this.mDialog != null) {
            this.mDialog.removePaymentWindow();
        }
        if (this.mDialogX != null) {
            this.mDialogX.removePaymentWindow();
        }
    }

    public void dismissWindow() {
        if (this.mDialog != null) {
            this.mDialog.dismiss();
        }
        if (this.mDialogX != null) {
            this.mDialogX.dismiss();
        }
    }
}

