/*
 * Decompiled with CFR 0.152.
 */
package kr.co.bootpay.android.webview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.webkit.CookieManager;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Locale;
import kr.co.bootpay.android.api.BootpayInterface;
import kr.co.bootpay.android.constants.BootpayConstant;
import kr.co.bootpay.android.events.BootpayEventListener;
import kr.co.bootpay.android.events.JSInterfaceBridge;
import kr.co.bootpay.android.models.Payload;
import kr.co.bootpay.android.webview.BootpayWebViewChromeClient;
import kr.co.bootpay.android.webview.BootpayWebViewClient;
import org.json.JSONException;
import org.json.JSONObject;

public class BootpayWebView
extends WebView
implements BootpayInterface {
    Payload payload;
    BootpayWebViewClient mWebViewClient;
    BootpayEventListener mEventListener;
    @Nullable
    protected String injectedJS;
    @Nullable
    protected List<String> injectedJSBeforePayStart;

    public BootpayWebView(@NonNull Context context) {
        super(context);
        this.constructInit(context);
    }

    public BootpayWebView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.constructInit(context);
    }

    public BootpayWebView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.constructInit(context);
    }

    void constructInit(Context context) {
        this.payWebSettings(context);
        this.mWebViewClient = new BootpayWebViewClient();
        this.setWebViewClient(this.mWebViewClient);
        this.setWebChromeClient(new BootpayWebViewChromeClient(context));
    }

    void setIgnoreSSLError() {
    }

    public void setInjectedJS(@Nullable String injectedJS) {
        this.injectedJS = injectedJS;
    }

    public void setInjectedJSBeforePayStart(@Nullable List<String> injectedJSBeforePayStart) {
        this.injectedJSBeforePayStart = injectedJSBeforePayStart;
    }

    @SuppressLint(value={"JavascriptInterface"})
    void payWebSettings(Context context) {
        this.addJavascriptInterface(new BootpayJavascriptBridge(), "Android");
        this.getSettings().setAppCacheEnabled(true);
        this.getSettings().setAllowFileAccess(false);
        this.getSettings().setAllowContentAccess(false);
        this.getSettings().setBuiltInZoomControls(true);
        this.getSettings().setDisplayZoomControls(false);
        this.getSettings().setCacheMode(2);
        this.getSettings().setDomStorageEnabled(true);
        this.getSettings().setJavaScriptEnabled(true);
        this.getSettings().setJavaScriptCanOpenWindowsAutomatically(true);
        this.getSettings().setLoadsImagesAutomatically(true);
        this.getSettings().setLoadWithOverviewMode(true);
        this.getSettings().setUseWideViewPort(true);
        this.getSettings().setSupportMultipleWindows(true);
        if (Build.VERSION.SDK_INT >= 16) {
            this.getSettings().setAllowFileAccessFromFileURLs(false);
            this.getSettings().setAllowUniversalAccessFromFileURLs(false);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.getSettings().setMixedContentMode(0);
            CookieManager.getInstance().setAcceptCookie(true);
            CookieManager.getInstance().setAcceptThirdPartyCookies((WebView)this, true);
        }
    }

    @Override
    public void removePaymentWindow() {
        this.load("Bootpay.removePaymentWindow();");
    }

    public void startBootpay() {
        this.connectBootpay();
    }

    public void transactionConfirm(String data) {
        String scriptList = BootpayConstant.loadParams("Bootpay.confirm()", ".then( function (res) {", BootpayConstant.confirm(), BootpayConstant.issued(), BootpayConstant.done(), "}, function (res) {", BootpayConstant.error(), BootpayConstant.cancel(), "})");
        this.load(scriptList);
    }

    private void load(String script) {
        this.post(() -> this.loadUrl(String.format(Locale.KOREA, "javascript:(function(){%s})()", script)));
    }

    public void connectBootpay() {
        this.loadUrl("https://webview.bootpay.co.kr/4.0.7");
    }

    public void backPressed() {
        if (this.canGoBack()) {
            this.goBack();
        }
    }

    void evaluateJavascriptWithFallback(String script) {
        if (Build.VERSION.SDK_INT >= 19) {
            this.evaluateJavascript(script, null);
            return;
        }
        try {
            this.loadUrl("javascript:" + URLEncoder.encode(script, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    void callJavaScript(@Nullable String script) {
        if (this.getSettings().getJavaScriptEnabled() && script != null && !TextUtils.isEmpty((CharSequence)script)) {
            Log.d((String)"bootpay", (String)script);
            this.evaluateJavascriptWithFallback("(function() {\n" + script + ";\n})();");
        }
    }

    public void setEventListener(BootpayEventListener listener) {
        this.mEventListener = listener;
    }

    public void callInjectedJavaScript() {
        this.callJavaScript(this.injectedJS);
    }

    public void callInjectedJavaScriptBeforePayStart() {
        if (this.injectedJSBeforePayStart == null) {
            return;
        }
        for (String js : this.injectedJSBeforePayStart) {
            this.callJavaScript(js);
        }
    }

    public void receivePostMessage() {
        this.callJavaScript(BootpayConstant.message());
    }

    public void setIgnoreErrFailedForThisURL(@Nullable String url) {
        if (this.mWebViewClient != null) {
            this.mWebViewClient.setIgnoreErrFailedForThisURL(url);
        }
    }

    public BootpayEventListener getEventListener() {
        return this.mEventListener;
    }

    @Nullable
    public String getInjectedJS() {
        return this.injectedJS;
    }

    @Nullable
    public List<String> getInjectedJSBeforePayStart() {
        return this.injectedJSBeforePayStart;
    }

    public void setPayload(Payload payload) {
        this.payload = payload;
    }

    boolean isDisplaySuccess() {
        if (this.payload == null) {
            return false;
        }
        if (this.payload.getExtra() == null) {
            return false;
        }
        return this.payload.getExtra().isDisplaySuccessResult();
    }

    boolean isDisplayError() {
        if (this.payload == null) {
            return false;
        }
        if (this.payload.getExtra() == null) {
            return false;
        }
        return this.payload.getExtra().isDisplayErrorResult();
    }

    private class BootpayJavascriptBridge
    implements JSInterfaceBridge {
        private BootpayJavascriptBridge() {
        }

        @Override
        @JavascriptInterface
        public void error(String data) {
            if (BootpayWebView.this.mEventListener != null) {
                BootpayWebView.this.mEventListener.onError(data);
            }
        }

        @Override
        @JavascriptInterface
        public void close(String data) {
            if (BootpayWebView.this.mEventListener != null) {
                BootpayWebView.this.mEventListener.onClose(data);
            }
        }

        @Override
        @JavascriptInterface
        public void cancel(String data) {
            if (BootpayWebView.this.mEventListener != null) {
                BootpayWebView.this.mEventListener.onCancel(data);
            }
        }

        @Override
        @JavascriptInterface
        public void issued(String data) {
            if (BootpayWebView.this.mEventListener != null) {
                BootpayWebView.this.mEventListener.onIssued(data);
            }
        }

        @Override
        @JavascriptInterface
        public String confirm(String data) {
            boolean goTransaction = false;
            if (BootpayWebView.this.mEventListener != null) {
                goTransaction = BootpayWebView.this.mEventListener.onConfirm(data);
            }
            if (goTransaction) {
                BootpayWebView.this.transactionConfirm(data);
            }
            return String.valueOf(goTransaction);
        }

        @Override
        @JavascriptInterface
        public void done(String data) {
            if (BootpayWebView.this.mEventListener != null) {
                BootpayWebView.this.mEventListener.onDone(data);
            }
        }

        @Override
        @JavascriptInterface
        public void redirectEvent(String data) {
            Log.d((String)"bootpay", (String)("redirectEvent: " + data));
            if ("undefined".equals(data)) {
                return;
            }
            try {
                String event;
                JSONObject json = new JSONObject(data);
                switch (event = String.valueOf(json.get("event"))) {
                    case "error": {
                        this.error(data);
                        if (BootpayWebView.this.isDisplayError()) break;
                        this.close(data);
                        break;
                    }
                    case "close": {
                        this.close(data);
                        break;
                    }
                    case "cancel": {
                        this.cancel(data);
                        this.close(data);
                        break;
                    }
                    case "issued": {
                        this.issued(data);
                        if (BootpayWebView.this.isDisplaySuccess()) break;
                        this.close(data);
                        break;
                    }
                    case "confirm": {
                        this.confirm(data);
                        break;
                    }
                    case "done": {
                        this.done(data);
                        if (BootpayWebView.this.isDisplaySuccess()) break;
                        this.close(data);
                    }
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }
}

