/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import io.github.bonigarcia.wdm.DriverManagerType;
import io.github.bonigarcia.wdm.WebDriverManager;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.HttpRequestBase;

public class ChromeDriverManager
extends WebDriverManager {
    @Override
    protected DriverManagerType getDriverManagerType() {
        return DriverManagerType.CHROME;
    }

    @Override
    protected String getDriverName() {
        return "chromedriver";
    }

    @Override
    protected String getDriverVersion() {
        return this.config().getChromeDriverVersion();
    }

    @Override
    protected URL getDriverUrl() {
        return this.getDriverUrlCkeckingMirror(this.config().getChromeDriverUrl());
    }

    @Override
    protected Optional<URL> getMirrorUrl() {
        return Optional.of(this.config().getChromeDriverMirrorUrl());
    }

    @Override
    protected Optional<String> getExportParameter() {
        return Optional.of(this.config().getChromeDriverExport());
    }

    @Override
    protected void setDriverVersion(String version) {
        this.config().setChromeDriverVersion(version);
    }

    @Override
    protected void setDriverUrl(URL url) {
        this.config().setChromeDriverUrl(url);
    }

    @Override
    protected List<URL> getDrivers() throws IOException {
        Optional<URL> mirrorUrl = this.getMirrorUrl();
        if (mirrorUrl.isPresent() && this.config().isUseMirror()) {
            return this.getDriversFromMirror(mirrorUrl.get());
        }
        return this.getDriversFromXml(this.getDriverUrl());
    }

    @Override
    protected String getCurrentVersion(URL url, String driverName) {
        if (this.config().isUseMirror()) {
            int i = url.getFile().lastIndexOf("/");
            int j = url.getFile().substring(0, i).lastIndexOf("/") + 1;
            return url.getFile().substring(j, i);
        }
        return super.getCurrentVersion(url, driverName);
    }

    @Override
    protected Optional<String> getBrowserVersion() {
        String[] programFilesEnvs = new String[]{this.getProgramFilesEnv(), "LOCALAPPDATA", this.getOtherProgramFilesEnv()};
        return this.getDefaultBrowserVersion(programFilesEnvs, "\\\\Google\\\\Chrome\\\\Application\\\\chrome.exe", "google-chrome", "/Applications/Google Chrome.app/Contents/MacOS/Google Chrome", "--version", this.getDriverManagerType().toString());
    }

    @Override
    protected Optional<String> getLatestVersion() {
        String url = this.config().getChromeDriverUrl() + "LATEST_RELEASE";
        if (this.config.isUseMirror()) {
            url = this.config().getChromeDriverMirrorUrl() + "LATEST_RELEASE";
        }
        Optional<Object> version = Optional.empty();
        try {
            InputStream response = this.httpClient.execute((HttpRequestBase)this.httpClient.createHttpGet(new URL(url))).getEntity().getContent();
            version = Optional.of(IOUtils.toString((InputStream)response, (Charset)Charset.defaultCharset()));
        }
        catch (Exception e) {
            log.warn("Exception reading {} to get latest version of {}", new Object[]{url, this.getDriverName(), e});
        }
        if (version.isPresent()) {
            log.debug("Latest version of {} according to {} is {}", new Object[]{this.getDriverName(), url, version.get()});
        }
        return version;
    }
}

