/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import io.github.bonigarcia.wdm.Config;
import io.github.bonigarcia.wdm.DriverManagerType;
import io.github.bonigarcia.wdm.WebDriverManager;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;

public class PhantomJsDriverManager
extends WebDriverManager {
    private static final String BETA = "beta";

    public static synchronized WebDriverManager getInstance() {
        return PhantomJsDriverManager.phantomjs();
    }

    public PhantomJsDriverManager() {
        this.driverManagerType = DriverManagerType.PHANTOMJS;
        this.exportParameterKey = "wdm.phantomjsDriverExport";
        this.driverVersionKey = "wdm.phantomjsDriverVersion";
        this.driverUrlKey = "wdm.phantomjsDriverUrl";
        this.driverMirrorUrlKey = "wdm.phantomjsDriverMirrorUrl";
        this.driverName = Arrays.asList("phantomjs");
    }

    @Override
    protected List<URL> getDrivers() throws IOException {
        URL driverUrl = PhantomJsDriverManager.config().getDriverUrl(this.driverUrlKey);
        String driverNameString = Config.listToString(this.getDriverName());
        log.info("Reading {} to seek {}", (Object)driverUrl, (Object)driverNameString);
        return this.getDriversFromMirror(driverUrl);
    }

    @Override
    protected String getCurrentVersion(URL url, String driverName) {
        int matchIndex;
        String file = url.getFile();
        file = url.getFile().substring(file.lastIndexOf("/"), file.length());
        String currentVersion = file.substring((matchIndex = file.indexOf(driverName)) + driverName.length() + 1, file.length());
        int dashIndex = currentVersion.indexOf(45);
        if (dashIndex != -1) {
            String beta = currentVersion.substring(dashIndex + 1, dashIndex + 1 + BETA.length());
            if (beta.equalsIgnoreCase(BETA)) {
                dashIndex = currentVersion.indexOf(45, dashIndex + 1);
            }
            currentVersion = dashIndex != -1 ? currentVersion.substring(0, dashIndex) : "";
        } else {
            currentVersion = "";
        }
        return currentVersion;
    }

    @Override
    protected String preDownload(String target, String version) {
        int iSeparator = target.indexOf(version) - 1;
        int iDash = target.lastIndexOf(version) + version.length();
        int iPoint = target.lastIndexOf(".tar") != -1 ? target.lastIndexOf(".tar") : target.lastIndexOf(".zip");
        target = target.substring(0, iSeparator + 1) + target.substring(iDash + 1, iPoint) + target.substring(iSeparator);
        target = target.replace("beta-", "");
        return target;
    }

    @Override
    protected File postDownload(File archive) {
        log.trace("PhatomJS package name: {}", (Object)archive);
        File extractFolder = archive.getParentFile().listFiles(this.getFolderFilter())[0];
        log.trace("PhatomJS extract folder (to be deleted): {}", (Object)extractFolder);
        File binFolder = new File(extractFolder.getAbsoluteFile() + File.separator + "bin");
        int binaryIndex = 0;
        if (!binFolder.exists()) {
            binFolder = extractFolder;
            binaryIndex = 3;
        }
        log.trace("PhatomJS bin folder: {} (index {})", (Object)binFolder, (Object)binaryIndex);
        File phantomjs = binFolder.listFiles()[binaryIndex];
        log.trace("PhatomJS binary: {}", (Object)phantomjs);
        File target = new File(archive.getParentFile().getAbsolutePath(), phantomjs.getName());
        log.trace("PhatomJS target: {}", (Object)target);
        this.downloader.renameFile(phantomjs, target);
        this.downloader.deleteFolder(extractFolder);
        return target;
    }

    @Override
    protected boolean shouldCheckArchitecture() {
        return false;
    }
}

