/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.internal.LinkedTreeMap;
import io.github.bonigarcia.wdm.BrowserManager;
import io.github.bonigarcia.wdm.GitHubApi;
import io.github.bonigarcia.wdm.OperativeSystem;
import io.github.bonigarcia.wdm.WdmConfig;
import io.github.bonigarcia.wdm.WebDriverManagerException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FirefoxDriverManager
extends BrowserManager {
    public static synchronized BrowserManager getInstance() {
        if (instance == null || !instance.getClass().equals(FirefoxDriverManager.class)) {
            instance = new FirefoxDriverManager();
        }
        return instance;
    }

    @Override
    protected List<URL> getDrivers() throws IOException {
        List<URL> urls;
        URL driverUrl = this.getDriverUrl();
        if (this.isUsingTaobaoMirror()) {
            urls = this.getDriversFromMirror(driverUrl);
        } else {
            log.info("Reading {} to seek {}", (Object)driverUrl, this.getDriverName());
            String driverVersion = this.versionToDownload;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.openGitHubConnection(driverUrl)));){
                GsonBuilder gsonBuilder = new GsonBuilder();
                Gson gson = gsonBuilder.create();
                GitHubApi[] releaseArray = (GitHubApi[])gson.fromJson((Reader)reader, GitHubApi[].class);
                if (driverVersion != null) {
                    releaseArray = new GitHubApi[]{this.getVersion(releaseArray, driverVersion)};
                }
                urls = new ArrayList<URL>();
                for (GitHubApi release : releaseArray) {
                    if (release == null) continue;
                    List<LinkedTreeMap<String, Object>> assets = release.getAssets();
                    for (LinkedTreeMap<String, Object> asset : assets) {
                        urls.add(new URL(asset.get((Object)"browser_download_url").toString()));
                    }
                }
            }
        }
        return urls;
    }

    protected GitHubApi getVersion(GitHubApi[] releaseArray, String version) {
        GitHubApi out = null;
        for (GitHubApi release : releaseArray) {
            if ((release.getName() == null || !release.getName().contains(version)) && (release.getTagName() == null || !release.getTagName().contains(version))) continue;
            out = release;
            break;
        }
        return out;
    }

    @Override
    protected String getExportParameter() {
        return WdmConfig.getString("wdm.geckoDriverExport");
    }

    @Override
    protected String getDriverVersionKey() {
        return "wdm.geckoDriverVersion";
    }

    @Override
    protected List<String> getDriverName() {
        return Arrays.asList("wires", "geckodriver");
    }

    @Override
    protected String getDriverUrlKey() {
        return "wdm.geckoDriverUrl";
    }

    @Override
    protected String getCurrentVersion(URL url, String driverName) throws MalformedURLException {
        String currentVersion = url.getFile().substring(url.getFile().indexOf("-") + 1, url.getFile().lastIndexOf("-"));
        if (currentVersion.startsWith("v")) {
            currentVersion = currentVersion.substring(1);
        }
        return currentVersion;
    }

    @Override
    protected String preDownload(String target, String version) throws IOException {
        int iSeparator = target.indexOf(version) - 1;
        int iDash = target.lastIndexOf(version) + version.length();
        int iPoint = target.lastIndexOf("tar.gz") != -1 ? target.lastIndexOf(".tar.gz") : (target.lastIndexOf(".gz") != -1 ? target.lastIndexOf(".gz") : target.lastIndexOf(".zip"));
        target = target.substring(0, iSeparator + 1) + target.substring(iDash + 1, iPoint).toLowerCase() + target.substring(iSeparator);
        return target;
    }

    @Override
    public BrowserManager useTaobaoMirror() {
        String taobaoUrl = null;
        try {
            taobaoUrl = WdmConfig.getString(WdmConfig.getString("wdm.geckoDriverTaobaoUrl"));
            this.driverUrl = new URL(taobaoUrl);
        }
        catch (MalformedURLException e) {
            String errorMessage = "Malformed URL " + taobaoUrl;
            log.error(errorMessage, (Throwable)e);
            throw new WebDriverManagerException(errorMessage, e);
        }
        return instance;
    }

    @Override
    protected boolean shouldCheckArchitecture(String driverName) {
        return !MY_OS_NAME.contains(OperativeSystem.mac.name());
    }
}

