/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import io.github.bonigarcia.wdm.Architecture;
import io.github.bonigarcia.wdm.Downloader;
import io.github.bonigarcia.wdm.DriverVersion;
import io.github.bonigarcia.wdm.EdgeDriverManager;
import io.github.bonigarcia.wdm.OperativeSystem;
import io.github.bonigarcia.wdm.WdmConfig;
import io.github.bonigarcia.wdm.WdmHttpClient;
import io.github.bonigarcia.wdm.WdmUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public abstract class BrowserManager {
    protected static final Logger log = LoggerFactory.getLogger(BrowserManager.class);
    public static final String TAOBAO_MIRROR = "npm.taobao.org";
    public static final String SEPARATOR = "/";
    public static final Architecture DEFAULT_ARCH = Architecture.valueOf("x" + System.getProperty("sun.arch.data.model"));
    public static final String MY_OS_NAME = BrowserManager.getOsName();
    protected static BrowserManager instance;
    protected String versionToDownload;
    protected boolean mirrorLog = false;
    protected String version;
    protected Architecture architecture;
    protected boolean forceCache = false;
    protected boolean forceDownload = false;
    protected boolean useBetaVersions = WdmConfig.getBoolean("wdm.useBetaVersions");
    protected URL driverUrl;
    protected String proxy;
    protected String binaryPath;
    protected List<String> listVersions;
    protected boolean triedWithCache = false;
    protected String proxyUser;
    protected String proxyPass;
    protected WdmHttpClient httpClient;

    protected abstract List<URL> getDrivers() throws Exception;

    protected abstract String getExportParameter();

    protected abstract String getDriverVersionKey();

    protected abstract List<String> getDriverName();

    protected abstract String getDriverUrlKey();

    protected String getDriverVersion() {
        return this.version == null ? WdmConfig.getString(this.getDriverVersionKey()) : this.version;
    }

    protected URL getDriverUrl() throws MalformedURLException {
        return this.driverUrl == null ? WdmConfig.getUrl(this.getDriverUrlKey()) : this.driverUrl;
    }

    protected String preDownload(String target, String version) throws IOException {
        return target;
    }

    protected File postDownload(File archive) throws IOException {
        File[] ls;
        File target = archive;
        for (File f : ls = archive.getParentFile().listFiles()) {
            if (!this.isExecutable(f)) continue;
            target = f;
            break;
        }
        return target;
    }

    protected String getCurrentVersion(URL url, String driverName) throws MalformedURLException {
        return url.getFile().substring(url.getFile().indexOf(SEPARATOR) + 1, url.getFile().lastIndexOf(SEPARATOR));
    }

    protected void manage(Architecture arch, DriverVersion version) {
        this.manage(arch, version.name());
    }

    protected void manage(Architecture arch, String version) {
        this.httpClient = new WdmHttpClient.Builder().proxy(this.proxy).proxyUser(this.proxyUser).proxyPass(this.proxyPass).build();
        try (WdmHttpClient httpClient = this.httpClient;){
            Downloader downloader = new Downloader(this, httpClient);
            if (this.forceDownload) {
                downloader.forceDownload();
            }
            boolean getLatest = version == null || version.isEmpty() || version.equalsIgnoreCase(DriverVersion.LATEST.name()) || version.equalsIgnoreCase(DriverVersion.NOT_SPECIFIED.name());
            boolean forceCache = this.forceCache || WdmConfig.getBoolean("wdm.forceCache") || !this.isNetAvailable();
            String driverInCache = null;
            if (forceCache) {
                driverInCache = this.forceCache(downloader.getTargetPath());
            } else if (!getLatest) {
                this.versionToDownload = version;
                driverInCache = this.existsDriverInCache(downloader.getTargetPath(), version, arch);
            }
            if (driverInCache != null) {
                this.versionToDownload = version;
                log.debug("Driver for {} {} found in cache {}", new Object[]{this.getDriverName(), this.versionToDownload, driverInCache});
                this.exportDriver(this.getExportParameter(), driverInCache);
            } else {
                List<URL> urls = this.getDrivers();
                if (!urls.isEmpty()) {
                    List<URL> candidateUrls;
                    boolean continueSearchingVersion;
                    do {
                        candidateUrls = getLatest ? this.getLatest(urls, this.getDriverName()) : this.getVersion(urls, this.getDriverName(), version);
                        if (this.versionToDownload == null) break;
                        log.trace("All URLs: {}", urls);
                        log.trace("Candidate URLs: {}", candidateUrls);
                        if (this.getClass().equals(EdgeDriverManager.class)) {
                            continueSearchingVersion = false;
                            continue;
                        }
                        candidateUrls = this.filter(candidateUrls, arch);
                        if (SystemUtils.IS_OS_LINUX && this.getDriverName().contains("phantomjs")) {
                            candidateUrls = this.filterByDistro(candidateUrls, this.getDistroName(), "2.5.0");
                        }
                        boolean bl = continueSearchingVersion = candidateUrls.isEmpty() && getLatest;
                        if (!continueSearchingVersion) continue;
                        log.info("No valid binary found for {} {}", this.getDriverName(), (Object)this.versionToDownload);
                        urls = this.removeFromList(urls, this.versionToDownload);
                        this.versionToDownload = null;
                    } while (continueSearchingVersion);
                    if (candidateUrls.isEmpty()) {
                        String versionStr = getLatest ? "(latest version)" : version;
                        String errMessage = this.getDriverName() + " " + versionStr + " for " + MY_OS_NAME + arch.toString() + " not found in " + this.getDriverUrl();
                        log.error(errMessage);
                        throw new RuntimeException(errMessage);
                    }
                    for (URL url : candidateUrls) {
                        String export = candidateUrls.contains(url) ? this.getExportParameter() : null;
                        downloader.download(url, this.versionToDownload, export, this.getDriverName());
                    }
                }
            }
        }
        catch (Exception e) {
            if (!this.forceCache && !this.triedWithCache) {
                this.forceCache = true;
                this.triedWithCache = true;
                log.warn("There was an error managing {} {} ({}) ... trying again forcing to use cache", new Object[]{this.getDriverName(), version, e.getMessage()});
                this.manage(arch, version);
            }
            throw new RuntimeException(e);
        }
    }

    protected String forceCache(String repository) throws IOException {
        String driverInCache = null;
        for (String driverName : this.getDriverName()) {
            log.trace("Checking if {} exists in cache {}", (Object)driverName, (Object)repository);
            Collection listFiles = FileUtils.listFiles((File)new File(repository), null, (boolean)true);
            Object[] array = listFiles.toArray();
            Arrays.sort(array, Collections.reverseOrder());
            for (Object f : array) {
                driverInCache = f.toString();
                log.trace("Checking {}", (Object)driverInCache);
                if (driverInCache.contains(driverName) && this.isExecutable(new File(driverInCache))) {
                    log.info("Found {} in cache: {} ", (Object)driverName, (Object)driverInCache);
                    break;
                }
                driverInCache = null;
            }
            if (driverInCache != null) break;
            log.trace("{} do not exist in cache {}", (Object)driverName, (Object)repository);
        }
        return driverInCache;
    }

    protected String existsDriverInCache(String repository, String driverVersion, Architecture arch) throws IOException {
        String driverInCache = null;
        for (String driverName : this.getDriverName()) {
            log.trace("Checking if {} {} ({} bits) exists in cache {}", new Object[]{driverName, driverVersion, arch, repository});
            Collection listFiles = FileUtils.listFiles((File)new File(repository), null, (boolean)true);
            Object[] array = listFiles.toArray();
            Arrays.sort(array, Collections.reverseOrder());
            for (Object f : array) {
                driverInCache = f.toString();
                boolean architecture = !this.shouldCheckArchitecture(driverName) || driverInCache.contains(arch.toString());
                log.trace("Checking {}", (Object)driverInCache);
                if (driverInCache.contains(driverVersion) && driverInCache.contains(driverName) && architecture) {
                    if (!this.isExecutable(new File(driverInCache))) continue;
                    log.debug("Found {} {} ({} bits) in cache: {}", new Object[]{driverVersion, driverName, arch, driverInCache});
                    break;
                }
                driverInCache = null;
            }
            if (driverInCache != null) break;
            log.trace("{} {} ({} bits) do not exist in cache {}", new Object[]{driverVersion, driverName, arch, repository});
        }
        return driverInCache;
    }

    public boolean isExecutable(File file) {
        return SystemUtils.IS_OS_WINDOWS ? file.getName().toLowerCase().endsWith(".exe") : file.canExecute();
    }

    protected boolean shouldCheckArchitecture(String driverName) {
        return true;
    }

    protected boolean isNetAvailable() {
        try {
            if (!this.httpClient.isValid(this.getDriverUrl())) {
                log.warn("Page not available. Forcing the use of cache");
                return false;
            }
        }
        catch (IOException e) {
            log.warn("Network not available. Forcing the use of cache");
            return false;
        }
        return true;
    }

    protected List<URL> filter(List<URL> list, Architecture arch) {
        log.trace("{} {} - URLs before filtering: {}", new Object[]{this.getDriverName(), this.versionToDownload, list});
        ArrayList<URL> out = new ArrayList<URL>();
        for (URL url : list) {
            for (OperativeSystem os : OperativeSystem.values()) {
                if ((!MY_OS_NAME.contains(os.name()) || !url.getFile().toLowerCase().contains(os.name())) && !this.getDriverName().contains("IEDriverServer") && (!SystemUtils.IS_OS_MAC || !url.getFile().toLowerCase().contains("osx")) || out.contains(url)) continue;
                out.add(url);
            }
        }
        log.trace("{} {} - URLs after filtering by OS ({}): {}", new Object[]{this.getDriverName(), this.versionToDownload, MY_OS_NAME, out});
        if (out.size() > 1 && arch != null) {
            for (URL url : list) {
                if (arch == Architecture.x32 && (url.getFile().contains("x86") && !url.getFile().contains("64") || url.getFile().contains("i686")) || url.getFile().contains(arch.toString())) continue;
                out.remove(url);
            }
        }
        log.trace("{} {} - URLs after filtering by architecture ({}): {}", new Object[]{this.getDriverName(), this.versionToDownload, arch, out});
        return out;
    }

    protected List<URL> filterByDistro(List<URL> list, String distro, String version) throws IOException {
        log.trace("{} {} - URLs before filtering by distro: {}", new Object[]{this.getDriverName(), this.versionToDownload, list});
        ArrayList<URL> out = new ArrayList<URL>(list);
        for (URL url : list) {
            if (!url.getFile().contains(version) || url.getFile().contains(distro)) continue;
            out.remove(url);
        }
        log.trace("{} {} - URLs after filtering by Linux distribution ({}): {}", new Object[]{this.getDriverName(), this.versionToDownload, distro, out});
        return out;
    }

    protected String getDistroName() throws IOException {
        File fileVersion;
        String out = "";
        String key = "UBUNTU_CODENAME";
        File dir = new File("/etc/");
        File[] fileList = new File[]{};
        if (dir.exists()) {
            fileList = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String filename) {
                    return filename.endsWith("-release");
                }
            });
        }
        if ((fileVersion = new File("/proc/version")).exists()) {
            fileList = Arrays.copyOf(fileList, fileList.length + 1);
            fileList[fileList.length - 1] = fileVersion;
        }
        for (File f : fileList) {
            if (f.isDirectory()) continue;
            try (BufferedReader myReader = new BufferedReader(new FileReader(f));){
                String strLine = null;
                while ((strLine = myReader.readLine()) != null) {
                    if (!strLine.contains("UBUNTU_CODENAME")) continue;
                    int beginIndex = "UBUNTU_CODENAME".length();
                    out = strLine.substring(beginIndex + 1);
                }
            }
        }
        return out;
    }

    protected List<URL> removeFromList(List<URL> list, String version) {
        ArrayList<URL> out = new ArrayList<URL>(list);
        for (URL url : list) {
            if (!url.getFile().contains(version)) continue;
            out.remove(url);
        }
        return out;
    }

    protected List<URL> getVersion(List<URL> list, List<String> match, String version) {
        int i;
        ArrayList<URL> out = new ArrayList<URL>();
        if (this.getDriverName().contains("MicrosoftWebDriver") && (i = this.listVersions.indexOf(version)) != -1) {
            out.add(list.get(i));
        }
        for (String s : match) {
            Collections.reverse(list);
            for (URL url : list) {
                if (!url.getFile().contains(s) || !url.getFile().contains(version) || url.getFile().contains("-symbols")) continue;
                out.add(url);
            }
        }
        this.versionToDownload = version;
        log.debug("Using {} {}", match, (Object)version);
        return out;
    }

    protected List<URL> getLatest(List<URL> list, List<String> match) {
        log.trace("Checking the lastest version of {}", match);
        log.trace("Input URL list {}", list);
        ArrayList<URL> out = new ArrayList<URL>();
        if (this.getDriverName().contains("MicrosoftWebDriver")) {
            this.versionToDownload = this.listVersions.iterator().next();
            out.add(list.iterator().next());
            log.info("Latest version of MicrosoftWebDriver is {}", (Object)this.versionToDownload);
            return out;
        }
        Collections.reverse(list);
        ArrayList<URL> copyOfList = new ArrayList<URL>(list);
        for (URL url : copyOfList) {
            for (String driverName : match) {
                try {
                    if (!this.useBetaVersions && url.getFile().toLowerCase().contains("beta") || !url.getFile().contains(driverName)) continue;
                    log.trace("URL {} match with {}", (Object)url, (Object)driverName);
                    String currentVersion = this.getCurrentVersion(url, driverName);
                    if (currentVersion.equalsIgnoreCase(driverName)) continue;
                    if (this.versionToDownload == null) {
                        this.versionToDownload = currentVersion;
                    }
                    if (this.versionCompare(currentVersion, this.versionToDownload) > 0) {
                        this.versionToDownload = currentVersion;
                        out.clear();
                    }
                    if (!url.getFile().contains(this.versionToDownload)) continue;
                    out.add(url);
                }
                catch (Exception e) {
                    log.trace("There was a problem with URL {} : {}", (Object)url.toString(), (Object)e.getMessage());
                    list.remove(url);
                }
            }
        }
        log.info("Latest version of {} is {}", match, (Object)this.versionToDownload);
        return out;
    }

    protected boolean isUsingTaobaoMirror() throws MalformedURLException {
        return this.getDriverUrl().getHost().equalsIgnoreCase(TAOBAO_MIRROR);
    }

    protected Integer versionCompare(String str1, String str2) {
        int i;
        Object[] vals1 = str1.replaceAll("v", "").split("\\.");
        Object[] vals2 = str2.replaceAll("v", "").split("\\.");
        log.trace("Comparing {} to {}", (Object)str1, (Object)str2);
        if (vals1[0].equals("")) {
            vals1[0] = "0";
        }
        if (vals2[0].equals("")) {
            vals2[0] = "0";
        }
        for (i = 0; i < vals1.length && i < vals2.length && ((String)vals1[i]).equals(vals2[i]); ++i) {
        }
        log.trace("Version 1 {}", (Object)Arrays.toString(vals1));
        log.trace("Version 2 {}", (Object)Arrays.toString(vals2));
        if (i < vals1.length && i < vals2.length) {
            int diff = Integer.valueOf((String)vals1[i]).compareTo(Integer.valueOf((String)vals2[i]));
            int signum = Integer.signum(diff);
            log.trace("[1] Returning {}", (Object)signum);
            return signum;
        }
        int signum = Integer.signum(vals1.length - vals2.length);
        log.trace("[2] Returning {}", (Object)signum);
        return signum;
    }

    protected List<URL> getDriversFromMirror(URL driverUrl) throws IOException {
        if (!this.mirrorLog) {
            log.info("Crawling driver list from mirror {}", (Object)driverUrl);
            this.mirrorLog = true;
        } else {
            log.trace("[Recursive call] Crawling driver list from mirror {}", (Object)driverUrl);
        }
        String driverStr = driverUrl.toString();
        String driverUrlContent = driverUrl.getPath();
        int timeout = (int)TimeUnit.SECONDS.toMillis(WdmConfig.getInt("wdm.timeout"));
        WdmHttpClient.Response response = this.httpClient.execute(new WdmHttpClient.Get(driverStr, timeout));
        try (InputStream in = response.getContent();){
            Document doc = Jsoup.parse((InputStream)in, null, (String)"");
            Iterator iterator = doc.select("a").iterator();
            ArrayList<URL> urlList = new ArrayList<URL>();
            while (iterator.hasNext()) {
                String link = ((org.jsoup.nodes.Element)iterator.next()).attr("href");
                if (link.contains("mirror") && link.endsWith(SEPARATOR)) {
                    urlList.addAll(this.getDriversFromMirror(new URL(driverStr + link.replace(driverUrlContent, ""))));
                    continue;
                }
                if (!link.startsWith(driverUrlContent) || link.contains("icons")) continue;
                urlList.add(new URL(driverStr + link.replace(driverUrlContent, "")));
            }
            ArrayList<URL> arrayList = urlList;
            return arrayList;
        }
    }

    protected List<URL> getDriversFromXml(URL driverUrl, List<String> driverBinary) throws Exception {
        log.info("Reading {} to seek {}", (Object)driverUrl, this.getDriverName());
        ArrayList<URL> urls = new ArrayList<URL>();
        int retries = 1;
        int maxRetries = WdmConfig.getInt("wdm.seekErrorRetries");
        while (true) {
            try {
                WdmHttpClient.Response response = this.httpClient.execute(new WdmHttpClient.Get(driverUrl));
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(response.getContent()));){
                    org.w3c.dom.Document xml = this.loadXML(reader);
                    XPath xPath = XPathFactory.newInstance().newXPath();
                    NodeList nodes = (NodeList)xPath.evaluate("//Contents/Key", xml.getDocumentElement(), XPathConstants.NODESET);
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Element e = (Element)nodes.item(i);
                        String version = e.getChildNodes().item(0).getNodeValue();
                        urls.add(new URL(driverUrl + version));
                    }
                }
            }
            catch (Throwable e) {
                log.warn("[{}/{}] Exception reading {} to seek {}: {} {}", new Object[]{retries, maxRetries, driverUrl, this.getDriverName(), e.getClass().getName(), e.getMessage(), e});
                if (++retries <= maxRetries) continue;
                throw e;
            }
            break;
        }
        return urls;
    }

    protected org.w3c.dom.Document loadXML(Reader reader) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputSource is = new InputSource(reader);
        return builder.parse(is);
    }

    protected static String getOsName() {
        String os = System.getProperty("os.name").toLowerCase();
        if (SystemUtils.IS_OS_WINDOWS) {
            os = "win";
        } else if (SystemUtils.IS_OS_LINUX) {
            os = "linux";
        } else if (SystemUtils.IS_OS_MAC) {
            os = "mac";
        }
        return os;
    }

    protected void exportDriver(String variableName, String variableValue) {
        log.info("Exporting {} as {}", (Object)variableName, (Object)variableValue);
        this.binaryPath = variableValue;
        System.setProperty(variableName, variableValue);
    }

    protected InputStream openGitHubConnection(URL driverUrl) throws IOException {
        WdmHttpClient.Get get = new WdmHttpClient.Get(driverUrl).addHeader("User-Agent", "Mozilla/5.0").addHeader("Connection", "keep-alive");
        String gitHubTokenName = WdmConfig.getString("wdm.gitHubTokenName");
        gitHubTokenName = WdmUtils.isNullOrEmpty(gitHubTokenName) ? System.getenv("WDM_GIT_HUB_TOKEN_NAME") : gitHubTokenName;
        String gitHubTokenSecret = WdmConfig.getString("wdm.gitHubTokenSecret");
        String string = gitHubTokenSecret = WdmUtils.isNullOrEmpty(gitHubTokenSecret) ? System.getenv("WDM_GIT_HUB_TOKEN_SECRET") : gitHubTokenSecret;
        if (!WdmUtils.isNullOrEmpty(gitHubTokenName) && !WdmUtils.isNullOrEmpty(gitHubTokenSecret)) {
            String userpass = gitHubTokenName + ":" + gitHubTokenSecret;
            String basicAuth = "Basic " + new String(new Base64().encode(userpass.getBytes()));
            get.addHeader("Authorization", basicAuth);
        }
        return this.httpClient.execute(get).getContent();
    }

    @Deprecated
    protected Proxy createProxy() {
        return this.httpClient.createProxy(this.proxy);
    }

    public void setup() {
        Architecture architecture = this.architecture == null ? DEFAULT_ARCH : this.architecture;
        String driverVersion = this.getDriverVersion();
        String version = WdmUtils.isNullOrEmpty(driverVersion) ? DriverVersion.NOT_SPECIFIED.name() : driverVersion;
        this.setup(architecture, version);
    }

    @Deprecated
    public void setup(String version) {
        Architecture architecture = this.architecture == null ? DEFAULT_ARCH : this.architecture;
        this.setup(architecture, version);
    }

    @Deprecated
    public void setup(Architecture architecture) {
        String driverVersion = this.getDriverVersion();
        String version = WdmUtils.isNullOrEmpty(driverVersion) ? DriverVersion.NOT_SPECIFIED.name() : driverVersion;
        this.setup(architecture, version);
    }

    @Deprecated
    public void setup(Architecture architecture, String version) {
        String driverVersion = this.getDriverVersion();
        if (!driverVersion.equalsIgnoreCase(DriverVersion.LATEST.name()) || version.equals(DriverVersion.NOT_SPECIFIED.name())) {
            version = driverVersion;
        }
        instance.manage(architecture, version);
    }

    public String getDownloadedVersion() {
        return this.versionToDownload;
    }

    public BrowserManager version(String version) {
        this.version = version;
        return this;
    }

    public BrowserManager architecture(Architecture architecture) {
        this.architecture = architecture;
        return this;
    }

    public BrowserManager arch32() {
        this.architecture = Architecture.x32;
        return this;
    }

    public BrowserManager arch64() {
        this.architecture = Architecture.x64;
        return this;
    }

    public BrowserManager forceCache() {
        this.forceCache = true;
        return this;
    }

    public BrowserManager forceDownload() {
        this.forceDownload = true;
        return this;
    }

    public BrowserManager driverRepositoryUrl(URL url) {
        this.driverUrl = url;
        return this;
    }

    public BrowserManager useTaobaoMirror() {
        throw new RuntimeException("Binaries for " + this.getDriverName() + " not available in taobao.org mirror (http://npm.taobao.org/mirrors/)");
    }

    public BrowserManager proxy(String proxy) {
        this.proxy = proxy;
        return this;
    }

    public BrowserManager proxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
        return this;
    }

    public BrowserManager proxyPass(String proxyPass) {
        this.proxyPass = proxyPass;
        return this;
    }

    public String getBinaryPath() {
        return this.binaryPath;
    }

    public BrowserManager useBetaVersions() {
        this.useBetaVersions = true;
        return this;
    }
}

