/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import com.google.common.base.Strings;
import io.github.bonigarcia.wdm.BrowserManager;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.StringTokenizer;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WdmHttpClient
implements Closeable {
    protected static final Logger log = LoggerFactory.getLogger(BrowserManager.class);
    private final CloseableHttpClient httpClient;

    private WdmHttpClient(String proxyUrl, String proxyUser, String proxyPass) {
        HttpHost proxyHost = this.createProxyHttpHost(proxyUrl);
        HttpClientBuilder builder = HttpClientBuilder.create();
        if (proxyHost != null) {
            builder.setProxy(proxyHost);
            BasicCredentialsProvider credentialsProvider = this.createBasicCredentialsProvider(proxyUrl, proxyUser, proxyPass, proxyHost);
            builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
        this.httpClient = builder.build();
    }

    Proxy createProxy(String proxyUrl) {
        URL url = this.determineProxyUrl(proxyUrl);
        if (url == null) {
            return null;
        }
        String proxyHost = url.getHost();
        int proxyPort = url.getPort() == -1 ? 80 : url.getPort();
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
    }

    public Response execute(Method method) throws IOException {
        CloseableHttpResponse response = this.httpClient.execute(method.toHttpUriRequest());
        if (response.getStatusLine().getStatusCode() >= 400) {
            throw new RuntimeException("A response error is detected. " + response.getStatusLine());
        }
        return new Response((HttpResponse)response);
    }

    public boolean isValid(URL url) throws IOException {
        CloseableHttpResponse response = this.httpClient.execute(new Options(url).toHttpUriRequest());
        if (response.getStatusLine().getStatusCode() >= 400) {
            if (log.isDebugEnabled()) {
                log.debug("A response error is detected. {}", (Object)response.getStatusLine());
            }
            return false;
        }
        return true;
    }

    private URL determineProxyUrl(String proxy) {
        String proxyInput;
        String string = proxyInput = Strings.isNullOrEmpty((String)proxy) ? System.getenv("HTTPS_PROXY") : proxy;
        if (Strings.isNullOrEmpty((String)proxyInput)) {
            return null;
        }
        try {
            return new URL(proxyInput.matches("^http[s]?://.*$") ? proxyInput : "http://" + proxyInput);
        }
        catch (MalformedURLException e) {
            log.error("Invalid proxy url {}", (Object)proxyInput, (Object)e);
            return null;
        }
    }

    private final HttpHost createProxyHttpHost(String proxyUrl) {
        Proxy proxy = this.createProxy(proxyUrl);
        if (proxy == null || proxy.address() == null) {
            return null;
        }
        if (!(proxy.address() instanceof InetSocketAddress)) {
            throw new RuntimeException("Detect an unsupported subclass of SocketAddress. Please use the InetSocketAddress or subclass. Actual:" + proxy.address().getClass());
        }
        InetSocketAddress proxyAddress = (InetSocketAddress)proxy.address();
        return new HttpHost(proxyAddress.getHostName(), proxyAddress.getPort());
    }

    private final BasicCredentialsProvider createBasicCredentialsProvider(String proxy, String proxyUser, String proxyPass, HttpHost proxyHost) {
        URL proxyUrl = this.determineProxyUrl(proxy);
        if (proxyUrl == null) {
            return null;
        }
        try {
            String username = null;
            String password = null;
            String userInfo = proxyUrl.getUserInfo();
            if (userInfo != null) {
                StringTokenizer st = new StringTokenizer(userInfo, ":");
                username = st.hasMoreTokens() ? URLDecoder.decode(st.nextToken(), StandardCharsets.UTF_8.name()) : null;
                password = st.hasMoreTokens() ? URLDecoder.decode(st.nextToken(), StandardCharsets.UTF_8.name()) : null;
            }
            String envProxyUser = System.getenv("HTTPS_PROXY_USER");
            String envProxyPass = System.getenv("HTTPS_PROXY_PASS");
            username = envProxyUser != null ? envProxyUser : username;
            password = envProxyPass != null ? envProxyPass : password;
            username = proxyUser != null ? proxyUser : username;
            String string = password = proxyPass != null ? proxyPass : password;
            if (username == null) {
                return null;
            }
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(proxyHost.getHostName(), proxyHost.getPort()), (Credentials)new UsernamePasswordCredentials(username, password));
            return credentialsProvider;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Invalid encoding.", e);
        }
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    public static final class Response {
        private final HttpResponse response;

        public Response(HttpResponse response) {
            this.response = response;
        }

        public InputStream getContent() throws IOException {
            return this.response.getEntity().getContent();
        }
    }

    public static final class Options
    implements Method {
        private final HttpOptions options;

        public Options(URL url) {
            this.options = new HttpOptions(url.toString());
        }

        @Override
        public HttpUriRequest toHttpUriRequest() {
            return this.options;
        }
    }

    public static final class Get
    implements Method {
        private final HttpGet get;
        private final RequestConfig config;

        public Get(URL url) {
            this.get = new HttpGet(url.toString());
            this.config = null;
        }

        public Get(String url, int socketTimeout) {
            this.get = new HttpGet(url);
            this.config = RequestConfig.custom().setSocketTimeout(socketTimeout).build();
        }

        public Get addHeader(String name, String value) {
            this.get.addHeader(name, value);
            return this;
        }

        @Override
        public HttpUriRequest toHttpUriRequest() {
            if (this.config != null) {
                this.get.setConfig(this.config);
            }
            return this.get;
        }
    }

    private static interface Method {
        public HttpUriRequest toHttpUriRequest();
    }

    public static class Builder {
        private String proxy;
        private String proxyUser;
        private String proxyPass;

        public Builder proxy(String proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder proxyUser(String proxyUser) {
            this.proxyUser = proxyUser;
            return this;
        }

        public Builder proxyPass(String proxyPass) {
            this.proxyPass = proxyPass;
            return this;
        }

        public WdmHttpClient build() {
            return new WdmHttpClient(this.proxy, this.proxyUser, this.proxyPass);
        }
    }
}

