/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import io.github.bonigarcia.wdm.BrowserManager;
import io.github.bonigarcia.wdm.WdmConfig;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class PhantomJsDriverManager
extends BrowserManager {
    private static PhantomJsDriverManager instance;

    public static synchronized PhantomJsDriverManager getInstance() {
        if (instance == null) {
            instance = new PhantomJsDriverManager();
        }
        return instance;
    }

    @Override
    public List<URL> getDrivers() throws Exception {
        String phantomjsDriverStr = WdmConfig.getString("wdm.phantomjsDriverUrl");
        log.debug("Reading {} to find out the latest version of PhantomJS driver", (Object)phantomjsDriverStr);
        URL phantomjsDriverUrl = new URL(phantomjsDriverStr);
        String phantomjsDriverUrlContent = phantomjsDriverUrl.getPath();
        Document doc = Jsoup.connect((String)phantomjsDriverStr).timeout((int)TimeUnit.SECONDS.toMillis(WdmConfig.getInt("wdm.timeout"))).get();
        Iterator iterator = doc.select("a").iterator();
        ArrayList<URL> urlList = new ArrayList<URL>();
        while (iterator.hasNext()) {
            String link = ((Element)iterator.next()).attr("href");
            if (!link.startsWith(phantomjsDriverUrlContent)) continue;
            urlList.add(new URL(phantomjsDriverStr + link.replace(phantomjsDriverUrlContent, "")));
        }
        return urlList;
    }

    @Override
    protected String getExportParameter() {
        return WdmConfig.getString("wdm.phantomjsDriverExport");
    }

    @Override
    protected String getDriverVersion() {
        return WdmConfig.getString("wdm.phantomjsDriverVersion");
    }

    @Override
    protected URL getDriverUrl() throws MalformedURLException {
        return WdmConfig.getUrl("wdm.phantomjsDriverUrl");
    }

    @Override
    protected List<String> getDriverName() {
        return Arrays.asList("phantomjs");
    }
}

