/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import io.github.bonigarcia.wdm.WdmConfig;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Downloader {
    protected static final Logger log = LoggerFactory.getLogger(Downloader.class);
    private static final String HOME = "~";

    public static final synchronized void download(URL url, String version, String export) throws IOException {
        File binary;
        File targetFile = new File(Downloader.getTarget(version, url));
        if (!targetFile.getParentFile().exists() || WdmConfig.getBoolean("wdm.override")) {
            log.info("Downloading {} to {}", (Object)url, (Object)targetFile);
            FileUtils.copyURLToFile((URL)url, (File)targetFile);
            binary = Downloader.unZip(targetFile);
            targetFile.delete();
        } else {
            binary = targetFile.getParentFile().listFiles()[0];
            log.info("Binary driver previously downloaded {}", (Object)binary);
        }
        if (export != null) {
            log.info("Exporting {} as {}", (Object)export, (Object)binary.toString());
            System.setProperty(export, binary.toString());
        }
    }

    public static final File unZip(String fileInput, String outputFolder) throws IOException {
        return null;
    }

    public static final File unZip(File folder) throws IOException {
        ZipFile zipFolder = new ZipFile(folder);
        Enumeration<? extends ZipEntry> enu = zipFolder.entries();
        File file = null;
        while (enu.hasMoreElements()) {
            ZipEntry zipEntry = enu.nextElement();
            String name = zipEntry.getName();
            long size = zipEntry.getSize();
            long compressedSize = zipEntry.getCompressedSize();
            log.info("Unzipping {} (size: {} KB, compressed size: {} KB)", new Object[]{name, size, compressedSize});
            file = new File(folder.getParentFile() + File.separator + name);
            if (!file.exists() || WdmConfig.getBoolean("wdm.override")) {
                int length;
                if (name.endsWith("/")) {
                    file.mkdirs();
                    continue;
                }
                File parent = file.getParentFile();
                if (parent != null) {
                    parent.mkdirs();
                }
                InputStream is = zipFolder.getInputStream(zipEntry);
                FileOutputStream fos = new FileOutputStream(file);
                byte[] bytes = new byte[1024];
                while ((length = is.read(bytes)) >= 0) {
                    fos.write(bytes, 0, length);
                }
                is.close();
                fos.close();
                file.setExecutable(true);
                continue;
            }
            log.info(file + " already exists");
        }
        zipFolder.close();
        return file.getAbsoluteFile();
    }

    private static final String getTarget(String version, URL url) throws IOException {
        String zip = url.getFile().substring(url.getFile().lastIndexOf("/"));
        int iFirst = zip.indexOf("_");
        int iLast = iFirst != zip.lastIndexOf("_") ? zip.lastIndexOf("_") : zip.length();
        String folder = zip.substring(0, iLast).replace(".zip", "").replace("_", File.separator);
        String targetPath = WdmConfig.getString("wdm.targetPath");
        if (targetPath.contains(HOME)) {
            targetPath = targetPath.replace(HOME, System.getProperty("user.home"));
        }
        return targetPath + folder + File.separator + version + File.separator + zip;
    }
}

