/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.seljup.handler;

import io.github.bonigarcia.seljup.AnnotationsReader;
import io.github.bonigarcia.seljup.Options;
import io.github.bonigarcia.seljup.config.Config;
import io.github.bonigarcia.seljup.handler.DriverHandler;
import java.io.IOException;
import java.lang.reflect.Parameter;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.ie.InternetExplorerOptions;

public class InternetExplorerDriverHandler
extends DriverHandler {
    public InternetExplorerDriverHandler(Config config, AnnotationsReader annotationsReader) {
        super(config, annotationsReader);
    }

    public InternetExplorerDriverHandler(Parameter parameter, ExtensionContext context, Config config, AnnotationsReader annotationsReader) {
        super(parameter, context, config, annotationsReader);
    }

    @Override
    public void resolve() {
        try {
            Optional testInstance = this.context.getTestInstance();
            Optional<Capabilities> capabilities = this.annotationsReader.getCapabilities(this.parameter, testInstance);
            InternetExplorerOptions internetExplorerOptions = (InternetExplorerOptions)this.getOptions(this.parameter, testInstance);
            if (capabilities.isPresent()) {
                internetExplorerOptions.merge(capabilities.get());
            }
            this.object = new InternetExplorerDriver(internetExplorerOptions);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public MutableCapabilities getOptions(Parameter parameter, Optional<Object> testInstance) throws IOException, IllegalAccessException {
        InternetExplorerOptions internetExplorerOptions = new InternetExplorerOptions();
        InternetExplorerOptions optionsFromAnnotatedField = this.annotationsReader.getFromAnnotatedField(testInstance, Options.class, InternetExplorerOptions.class);
        if (optionsFromAnnotatedField != null) {
            internetExplorerOptions = optionsFromAnnotatedField;
        }
        return internetExplorerOptions;
    }
}

