/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.seljup.handler;

import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.service.local.AppiumDriverLocalService;
import io.appium.java_client.service.local.AppiumServiceBuilder;
import io.appium.java_client.service.local.flags.GeneralServerFlag;
import io.appium.java_client.service.local.flags.ServerArgument;
import io.github.bonigarcia.seljup.AnnotationsReader;
import io.github.bonigarcia.seljup.SeleniumJupiterException;
import io.github.bonigarcia.seljup.config.Config;
import io.github.bonigarcia.seljup.handler.DriverHandler;
import java.io.File;
import java.lang.reflect.Parameter;
import java.net.URL;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.openqa.selenium.Capabilities;

public class AppiumDriverHandler
extends DriverHandler {
    private AppiumDriverLocalService appiumDriverLocalService;

    public AppiumDriverHandler(Parameter parameter, ExtensionContext context, Config config, AnnotationsReader annotationsReader) {
        super(parameter, context, config, annotationsReader);
    }

    @Override
    public void resolve() {
        try {
            Optional testInstance = this.context.getTestInstance();
            Optional<Capabilities> capabilities = this.annotationsReader.getCapabilities(this.parameter, testInstance);
            Optional<URL> url = this.annotationsReader.getUrl(this.parameter, testInstance, this.config.getSeleniumServerUrl());
            if (capabilities.isPresent()) {
                URL appiumServerUrl;
                if (url.isPresent()) {
                    appiumServerUrl = url.get();
                } else {
                    String appiumLogFile;
                    AppiumServiceBuilder builder = new AppiumServiceBuilder();
                    String logLevel = this.config.getAndroidAppiumLogLevel();
                    if (!logLevel.equals("")) {
                        builder.withArgument((ServerArgument)GeneralServerFlag.LOG_LEVEL, logLevel);
                    }
                    if (!(appiumLogFile = this.config.getAndroidAppiumLogFile()).equals("")) {
                        builder.withLogFile(new File(appiumLogFile));
                    }
                    this.appiumDriverLocalService = AppiumDriverLocalService.buildService((AppiumServiceBuilder)builder);
                    this.appiumDriverLocalService.start();
                    appiumServerUrl = this.appiumDriverLocalService.getUrl();
                }
                this.object = new AndroidDriver(appiumServerUrl, capabilities.get());
            } else {
                String noCapsMessage = "Was not possible to instantiate AppiumDriver: Capabilites not present";
                if (this.throwExceptionWhenNoDriver()) {
                    throw new SeleniumJupiterException(noCapsMessage);
                }
                log.warn(noCapsMessage);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void cleanup() {
        if (this.appiumDriverLocalService != null) {
            this.appiumDriverLocalService.stop();
            this.appiumDriverLocalService = null;
        }
    }
}

