/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.seljup.handler;

import io.github.bonigarcia.seljup.AnnotationsReader;
import io.github.bonigarcia.seljup.Options;
import io.github.bonigarcia.seljup.config.Config;
import io.github.bonigarcia.seljup.handler.DriverHandler;
import java.lang.reflect.Parameter;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.safari.SafariDriver;
import org.openqa.selenium.safari.SafariOptions;

public class SafariDriverHandler
extends DriverHandler {
    public SafariDriverHandler(Parameter parameter, ExtensionContext context, Config config, AnnotationsReader annotationsReader) {
        super(parameter, context, config, annotationsReader);
    }

    @Override
    public void resolve() {
        try {
            Optional testInstance = this.context.getTestInstance();
            Optional<Capabilities> capabilities = this.annotationsReader.getCapabilities(this.parameter, testInstance);
            SafariOptions safariOptions = (SafariOptions)this.getOptions(this.parameter, testInstance);
            if (capabilities.isPresent()) {
                safariOptions.merge(capabilities.get());
            }
            this.object = new SafariDriver(safariOptions);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public MutableCapabilities getOptions(Parameter parameter, Optional<Object> testInstance) throws IllegalAccessException {
        SafariOptions safariOptions = new SafariOptions();
        SafariOptions optionsFromAnnotatedField = this.annotationsReader.getFromAnnotatedField(testInstance, Options.class, SafariOptions.class);
        if (optionsFromAnnotatedField != null) {
            safariOptions = optionsFromAnnotatedField;
        }
        return safariOptions;
    }
}

