/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.seljup.handler;

import io.github.bonigarcia.seljup.AnnotationsReader;
import io.github.bonigarcia.seljup.Arguments;
import io.github.bonigarcia.seljup.Binary;
import io.github.bonigarcia.seljup.Extensions;
import io.github.bonigarcia.seljup.Options;
import io.github.bonigarcia.seljup.Preferences;
import io.github.bonigarcia.seljup.config.Config;
import io.github.bonigarcia.seljup.handler.DriverHandler;
import java.io.IOException;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;

public class FirefoxDriverHandler
extends DriverHandler {
    public FirefoxDriverHandler(Config config, AnnotationsReader annotationsReader) {
        super(config, annotationsReader);
    }

    public FirefoxDriverHandler(Parameter parameter, ExtensionContext context, Config config, AnnotationsReader annotationsReader) {
        super(parameter, context, config, annotationsReader);
    }

    @Override
    public void resolve() {
        try {
            Optional testInstance = this.context.getTestInstance();
            Optional<Capabilities> capabilities = this.annotationsReader.getCapabilities(this.parameter, testInstance);
            FirefoxOptions firefoxOptions = (FirefoxOptions)this.getOptions(this.parameter, testInstance);
            if (capabilities.isPresent()) {
                firefoxOptions.merge(capabilities.get());
            }
            this.object = new FirefoxDriver(firefoxOptions);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public MutableCapabilities getOptions(Parameter parameter, Optional<Object> testInstance) throws IOException, IllegalAccessException {
        FirefoxOptions firefoxOptions = new FirefoxOptions();
        if (parameter != null) {
            Binary binary;
            Extensions extensions;
            Arguments arguments = parameter.getAnnotation(Arguments.class);
            if (arguments != null) {
                Arrays.stream(arguments.value()).forEach(xva$0 -> firefoxOptions.addArguments(new String[]{xva$0}));
            }
            if ((extensions = parameter.getAnnotation(Extensions.class)) != null) {
                for (String extension : extensions.value()) {
                    FirefoxProfile firefoxProfile = new FirefoxProfile();
                    firefoxProfile.addExtension(this.getExtension(extension));
                    firefoxOptions.setProfile(firefoxProfile);
                }
            }
            if ((binary = parameter.getAnnotation(Binary.class)) != null) {
                firefoxOptions.setBinary(binary.value());
            }
            this.managePreferences(parameter, firefoxOptions);
            FirefoxOptions optionsFromAnnotatedField = this.annotationsReader.getFromAnnotatedField(testInstance, Options.class, FirefoxOptions.class);
            if (optionsFromAnnotatedField != null) {
                firefoxOptions = optionsFromAnnotatedField.merge((Capabilities)firefoxOptions);
            }
        }
        return firefoxOptions;
    }

    private void managePreferences(Parameter parameter, FirefoxOptions firefoxOptions) {
        Preferences preferences = parameter.getAnnotation(Preferences.class);
        if (preferences != null) {
            for (String preference : preferences.value()) {
                Optional<List<Object>> keyValue = this.annotationsReader.getKeyValue(preference);
                if (!keyValue.isPresent()) continue;
                String name = keyValue.get().get(0).toString();
                String value = keyValue.get().get(1).toString();
                if (this.annotationsReader.isBoolean(value)) {
                    firefoxOptions.addPreference(name, Boolean.valueOf(value).booleanValue());
                    continue;
                }
                if (this.annotationsReader.isNumeric(value)) {
                    firefoxOptions.addPreference(name, Integer.parseInt(value));
                    continue;
                }
                firefoxOptions.addPreference(name, value);
            }
        }
    }
}

