/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.seljup;

import com.spotify.docker.client.messages.PortBinding;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class DockerContainer {
    private String imageId;
    private Optional<Map<String, List<PortBinding>>> portBindings;
    private Optional<List<String>> binds;
    private Optional<List<String>> envs;
    private Optional<String> network;
    private Optional<List<String>> cmd;
    private Optional<List<String>> entryPoint;
    private boolean privileged;
    private String containerId;
    private String containerUrl;

    private DockerContainer(DockerBuilder builder) {
        this.imageId = builder.imageId;
        this.portBindings = builder.portBindings != null ? Optional.of(builder.portBindings) : Optional.empty();
        this.binds = builder.binds != null ? Optional.of(builder.binds) : Optional.empty();
        this.envs = builder.envs != null ? Optional.of(builder.envs) : Optional.empty();
        this.network = builder.network != null ? Optional.of(builder.network) : Optional.empty();
        this.cmd = builder.cmd != null ? Optional.of(builder.cmd) : Optional.empty();
        this.entryPoint = builder.entryPoint != null ? Optional.of(builder.entryPoint) : Optional.empty();
        this.privileged = builder.privileged;
    }

    public static DockerBuilder dockerBuilder(String imageId) {
        return new DockerBuilder(imageId);
    }

    public String getImageId() {
        return this.imageId;
    }

    public Optional<Map<String, List<PortBinding>>> getPortBindings() {
        return this.portBindings;
    }

    public Optional<List<String>> getBinds() {
        return this.binds;
    }

    public Optional<List<String>> getEnvs() {
        return this.envs;
    }

    public Optional<String> getNetwork() {
        return this.network;
    }

    public Optional<List<String>> getCmd() {
        return this.cmd;
    }

    public Optional<List<String>> getEntryPoint() {
        return this.entryPoint;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public String getContainerUrl() {
        return this.containerUrl;
    }

    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public void setContainerUrl(String containerUrl) {
        this.containerUrl = containerUrl;
    }

    public boolean isPrivileged() {
        return this.privileged;
    }

    public void setPrivileged(boolean privileged) {
        this.privileged = privileged;
    }

    public static class DockerBuilder {
        private String imageId;
        private Map<String, List<PortBinding>> portBindings;
        private List<String> binds;
        private List<String> envs;
        private List<String> cmd;
        private String network;
        private List<String> entryPoint;
        private boolean privileged = false;

        public DockerBuilder(String imageId) {
            this.imageId = imageId;
        }

        public DockerBuilder portBindings(Map<String, List<PortBinding>> portBindings) {
            this.portBindings = portBindings;
            return this;
        }

        public DockerBuilder binds(List<String> binds) {
            this.binds = binds;
            return this;
        }

        public DockerBuilder envs(List<String> envs) {
            this.envs = envs;
            return this;
        }

        public DockerBuilder network(String network) {
            this.network = network;
            return this;
        }

        public DockerBuilder cmd(List<String> cmd) {
            this.cmd = cmd;
            return this;
        }

        public DockerBuilder entryPoint(List<String> entryPoint) {
            this.entryPoint = entryPoint;
            return this;
        }

        public DockerBuilder privileged() {
            this.privileged = true;
            return this;
        }

        public DockerContainer build() {
            return new DockerContainer(this);
        }
    }
}

