/*
 * Decompiled with CFR 0.152.
 */
package org.treesitter;

import org.treesitter.CleanerRunner;
import org.treesitter.TSException;
import org.treesitter.TSLanguage;
import org.treesitter.TSParser;
import org.treesitter.TSQueryPredicateStep;
import org.treesitter.TSQueryPredicateStepType;

public class TSQuery {
    private final long ptr;

    private TSQuery(long ptr) {
        this.ptr = ptr;
        CleanerRunner.register(this, new TSQueryCleanRunner(ptr));
    }

    public TSQuery(TSLanguage language, String query) {
        this(TSParser.ts_query_new(language.getPtr(), query));
    }

    protected long getPtr() {
        return this.ptr;
    }

    public int getPatternCount() {
        return TSParser.ts_query_pattern_count(this.ptr);
    }

    public int getCaptureCount() {
        return TSParser.ts_query_capture_count(this.ptr);
    }

    public int getStringCount() {
        return TSParser.ts_query_string_count(this.ptr);
    }

    public int getStartByteForPattern(int patternIndex) {
        return TSParser.ts_query_start_byte_for_pattern(this.ptr, patternIndex);
    }

    public TSQueryPredicateStep[] getPredicateForPattern(int patternIndex) {
        return TSParser.ts_query_predicates_for_pattern(this.ptr, patternIndex);
    }

    public boolean isPatternRooted(int patternIndex) {
        return TSParser.ts_query_is_pattern_rooted(this.ptr, patternIndex);
    }

    public boolean isPatterNonLocal(int patternIndex) {
        return TSParser.ts_query_is_pattern_non_local(this.ptr, patternIndex);
    }

    public boolean isPatternGuaranteedAtStep(int byteOffset) {
        return TSParser.ts_query_is_pattern_guaranteed_at_step(this.ptr, byteOffset);
    }

    public String getCaptureNameForId(int captureId) {
        int captureCount = this.getCaptureCount();
        if (captureId >= captureCount) {
            throw new TSException("Invalid capture id: " + captureId);
        }
        return TSParser.ts_query_capture_name_for_id(this.ptr, captureId);
    }

    public int getCaptureQuantifierForId(int patternId, int captureId) {
        return TSParser.ts_query_capture_quantifier_for_id(this.ptr, patternId, captureId);
    }

    public String getStringValueForId(int id) {
        int patternCount = this.getPatternCount();
        for (int i = 0; i < patternCount; ++i) {
            TSQueryPredicateStep[] predicates = this.getPredicateForPattern(i);
            for (int j = 0; j < predicates.length; ++j) {
                TSQueryPredicateStep predicate = predicates[j];
                if (id != predicate.getValueId() || predicate.getType() != TSQueryPredicateStepType.TSQueryPredicateStepTypeString) continue;
                return TSParser.ts_query_string_value_for_id(this.ptr, predicate.getValueId());
            }
        }
        throw new TSException("Invalid string id: " + id);
    }

    public void disableCapture(String name) {
        TSParser.ts_query_disable_capture(this.ptr, name);
    }

    public void disablePattern(int index) {
        TSParser.ts_query_disable_pattern(this.ptr, index);
    }

    private static class TSQueryCleanRunner
    implements Runnable {
        private final long ptr;

        public TSQueryCleanRunner(long ptr) {
            this.ptr = ptr;
        }

        @Override
        public void run() {
            TSParser.ts_query_delete(this.ptr);
        }
    }
}

