/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.impl.spot;

import com.binance.connector.client.enums.HttpMethod;
import com.binance.connector.client.utils.ParameterChecker;
import com.binance.connector.client.utils.ProxyAuth;
import com.binance.connector.client.utils.RequestHandler;
import com.binance.connector.client.utils.signaturegenerator.HmacSignatureGenerator;
import com.binance.connector.client.utils.signaturegenerator.SignatureGenerator;
import java.util.Map;

public class Staking {
    private final String baseUrl;
    private final RequestHandler requestHandler;
    private final boolean showLimitUsage;
    private final String PRODUCT_LIST = "/sapi/v1/staking/productList";
    private final String PURCHASE = "/sapi/v1/staking/purchase";
    private final String REDEEM = "/sapi/v1/staking/redeem";
    private final String POSITION = "/sapi/v1/staking/position";
    private final String STAKING_RECORD = "/sapi/v1/staking/stakingRecord";
    private final String AUTO_STAKING = "/sapi/v1/staking/setAutoStaking";
    private final String LEFT_QUOTA = "/sapi/v1/staking/personalLeftQuota";
    private final String SUB_ETH_STAKING = "/sapi/v2/eth-staking/eth/stake";
    private final String REDEEM_ETH = "/sapi/v1/eth-staking/eth/redeem";
    private final String ETH_STAKING_HISTORY = "/sapi/v1/eth-staking/eth/history/stakingHistory";
    private final String ETH_STAKING_REDEEM_HISTORY = "/sapi/v1/eth-staking/eth/history/redemptionHistory";
    private final String ETH_STAKING_REWARDS_HISTORY = "/sapi/v1/eth-staking/eth/history/rewardsHistory";
    private final String ETH_STAKING_QUOTA = "/sapi/v1/eth-staking/eth/quota";
    private final String ETH_STAKING_RATE_HISTORY = "/sapi/v1/eth-staking/eth/history/rateHistory";
    private final String ETH_STAKING_ACCOUNT = "/sapi/v2/eth-staking/account";
    private final String WRAP_WBETH = "/sapi/v1/eth-staking/wbeth/wrap";
    private final String ETH_STAKING_WBETH_WRAP_HISTORY = "/sapi/v1/eth-staking/wbeth/history/wrapHistory";
    private final String ETH_STAKING_WBETH_UNWRAP_HISTORY = "/sapi/v1/eth-staking/wbeth/history/unwrapHistory";
    private final String ETH_STAKING_WBETH_REWARD_HISTORY = "/sapi/v1/eth-staking/eth/history/wbethRewardsHistory";

    public Staking(String baseUrl, String apiKey, String secretKey, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, new HmacSignatureGenerator(secretKey), proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public Staking(String baseUrl, String apiKey, SignatureGenerator signatureGenerator, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, signatureGenerator, proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public String productList(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "product", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/staking/productList", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String purchase(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "product", String.class);
        ParameterChecker.checkParameter(parameters, "productId", String.class);
        ParameterChecker.checkParameter(parameters, "amount", Double.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/staking/purchase", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String redeem(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "product", String.class);
        ParameterChecker.checkParameter(parameters, "productId", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/staking/redeem", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String getPosition(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "product", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/staking/position", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String stakingRecord(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "product", String.class);
        ParameterChecker.checkParameter(parameters, "txnType", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/staking/stakingRecord", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String setAutoStaking(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "product", String.class);
        ParameterChecker.checkParameter(parameters, "positionId", String.class);
        ParameterChecker.checkParameter(parameters, "renewable", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/staking/setAutoStaking", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String personalLeftQuota(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "product", String.class);
        ParameterChecker.checkParameter(parameters, "productId", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/staking/personalLeftQuota", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String subEthStaking(Map<String, Object> parameters) {
        ParameterChecker.checkRequiredParameter(parameters, "amount");
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v2/eth-staking/eth/stake", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String redeemEthStaking(Map<String, Object> parameters) {
        ParameterChecker.checkRequiredParameter(parameters, "amount");
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/eth-staking/eth/redeem", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String ethStakingSubHistory(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/eth-staking/eth/history/stakingHistory", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String ethStakingRedeemHistory(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/eth-staking/eth/history/redemptionHistory", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String ethStakingRewardsHistory(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/eth-staking/eth/history/rewardsHistory", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String ethStakingQuota(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/eth-staking/eth/quota", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String ethStakingRateHistory(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/eth-staking/eth/history/rateHistory", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String ethStakingAccount(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v2/eth-staking/account", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String wrapEthStakingWbeth(Map<String, Object> parameters) {
        ParameterChecker.checkRequiredParameter(parameters, "amount");
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/eth-staking/wbeth/wrap", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String ethStakingWbethWrapHistory(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/eth-staking/wbeth/history/wrapHistory", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String ethStakingWbethUnwrapHistory(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/eth-staking/wbeth/history/unwrapHistory", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String ethStakingWbethRewardHistory(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/eth-staking/eth/history/wbethRewardsHistory", parameters, HttpMethod.GET, this.showLimitUsage);
    }
}

