/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.impl.spot;

import com.binance.connector.client.enums.HttpMethod;
import com.binance.connector.client.utils.ParameterChecker;
import com.binance.connector.client.utils.ProxyAuth;
import com.binance.connector.client.utils.RequestHandler;
import com.binance.connector.client.utils.signaturegenerator.HmacSignatureGenerator;
import com.binance.connector.client.utils.signaturegenerator.SignatureGenerator;
import java.util.Map;

public class PortfolioMargin {
    private final String baseUrl;
    private final RequestHandler requestHandler;
    private final boolean showLimitUsage;
    private final String ACCOUNT = "/sapi/v1/portfolio/account";
    private final String COLLATERAL_RATE = "/sapi/v1/portfolio/collateralRate";
    private final String PM_LOAN = "/sapi/v1/portfolio/pmLoan";
    private final String REPAY = "/sapi/v1/portfolio/repay";
    private final String INTEREST_HISTORY = "/sapi/v1/portfolio/interest-history";
    private final String ASSET_INDEX_PRICE = "/sapi/v1/portfolio/asset-index-price";
    private final String AUTO_COLLECTION = "/sapi/v1/portfolio/auto-collection";
    private final String ASSET_COLLECTION = "/sapi/v1/portfolio/asset-collection";
    private final String BNB_TRANSFER = "/sapi/v1/portfolio/bnb-transfer";
    private final String SWITCH_AUTO_REPAY_FUTURES = "/sapi/v1/portfolio/repay-futures-switch";
    private final String AUTO_REPAY_FUTURES_STATUS = "/sapi/v1/portfolio/repay-futures-switch";
    private final String REPAY_FUTURES = "/sapi/v1/portfolio/repay-futures-negative-balance";
    private final String ASSET_LEVERAGE = "/sapi/v1/portfolio/margin-asset-leverage";

    public PortfolioMargin(String baseUrl, String apiKey, String secretKey, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, new HmacSignatureGenerator(secretKey), proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public PortfolioMargin(String baseUrl, String apiKey, SignatureGenerator signatureGenerator, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, signatureGenerator, proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public String getAccount(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/portfolio/account", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String collateralRate(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/portfolio/collateralRate", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String bankruptcyLoanRecord(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/portfolio/pmLoan", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String repay(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/portfolio/repay", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String interestHistory(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/portfolio/interest-history", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String assetIndexPrice(Map<String, Object> parameters) {
        return this.requestHandler.sendApiRequest(this.baseUrl, "/sapi/v1/portfolio/asset-index-price", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String autoCollection(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/portfolio/auto-collection", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String assetCollection(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "asset", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/portfolio/asset-collection", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String bnbTransfer(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "transferSide", String.class);
        ParameterChecker.checkRequiredParameter(parameters, "amount");
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/portfolio/bnb-transfer", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String switchAutoRepayFutures(Map<String, Object> parameters) {
        ParameterChecker.checkRequiredParameter(parameters, "autoRepay");
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/portfolio/repay-futures-switch", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String autoRepayFuturesStatus(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/portfolio/repay-futures-switch", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String repayFutures(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/portfolio/repay-futures-negative-balance", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String assetLeverage() {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/portfolio/margin-asset-leverage", null, HttpMethod.GET, this.showLimitUsage);
    }
}

