/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.impl.spot;

import com.binance.connector.client.enums.HttpMethod;
import com.binance.connector.client.utils.ParameterChecker;
import com.binance.connector.client.utils.ProxyAuth;
import com.binance.connector.client.utils.RequestHandler;
import com.binance.connector.client.utils.signaturegenerator.HmacSignatureGenerator;
import com.binance.connector.client.utils.signaturegenerator.SignatureGenerator;
import java.util.Map;

public class Margin {
    private final String baseUrl;
    private final RequestHandler requestHandler;
    private final boolean showLimitUsage;
    private final String CROSS_MARGIN_TRANSFER = "/sapi/v1/margin/transfer";
    private final String BORROW = "/sapi/v1/margin/loan";
    private final String REPAY = "/sapi/v1/margin/repay";
    private final String ASSET = "/sapi/v1/margin/asset";
    private final String PAIR = "/sapi/v1/margin/pair";
    private final String ALL_ASSETS = "/sapi/v1/margin/allAssets";
    private final String ALL_PAIRS = "/sapi/v1/margin/allPairs";
    private final String PRICE_INDEX = "/sapi/v1/margin/priceIndex";
    private final String ORDER = "/sapi/v1/margin/order";
    private final String OPEN_ORDERS = "/sapi/v1/margin/openOrders";
    private final String TRANSFER_HISTORY = "/sapi/v1/margin/transfer";
    private final String LOAN_RECORD = "/sapi/v1/margin/loan";
    private final String REPAY_RECORD = "/sapi/v1/margin/repay";
    private final String INTEREST_HISTORY = "/sapi/v1/margin/interestHistory";
    private final String FORCE_LIQUIDATION_RECORD = "/sapi/v1/margin/forceLiquidationRec";
    private final String ACCOUNT = "/sapi/v1/margin/account";
    private final String ALL_ORDERS = "/sapi/v1/margin/allOrders";
    private final String OCO_ORDER = "/sapi/v1/margin/order/oco";
    private final String ORDER_LIST = "/sapi/v1/margin/orderList";
    private final String GET_ALL_OCO = "/sapi/v1/margin/allOrderList";
    private final String GET_OPEN_OCO = "/sapi/v1/margin/openOrderList";
    private final String MY_TRADES = "/sapi/v1/margin/myTrades";
    private final String MAX_BORROW = "/sapi/v1/margin/maxBorrowable";
    private final String MAX_TRANSFERABLE = "/sapi/v1/margin/maxTransferable";
    private final String ISOLATED_TRANSFER = "/sapi/v1/margin/isolated/transfer";
    private final String ISOLATED_ACCOUNT = "/sapi/v1/margin/isolated/account";
    private final String ISOLATED_ACCOUNT_LIMIT = "/sapi/v1/margin/isolated/accountLimit";
    private final String ISOLATED_SYMBOL = "/sapi/v1/margin/isolated/pair";
    private final String ALL_ISOLATED_SYMBOL = "/sapi/v1/margin/isolated/allPairs";
    private final String BNB_BURN = "/sapi/v1/bnbBurn";
    private final String INTEREST_RATE_HIST = "/sapi/v1/margin/interestRateHistory";
    private final String CROSS_MARGIN_DATA = "/sapi/v1/margin/crossMarginData";
    private final String CROSS_MARGIN_COLLATERAL_RATIO = "/sapi/v1/margin/crossMarginCollateralRatio";
    private final String ADJUST_CROSS_MARGIN_MAX_LEVERAGE = "/sapi/v1/margin/max-leverage";
    private final String ISOLATED_MARGIN_DATA = "/sapi/v1/margin/isolatedMarginData";
    private final String ISOLATED_MARGIN_TIER = "/sapi/v1/margin/isolatedMarginTier";
    private final String ORDER_RATE_LIMIT = "/sapi/v1/margin/rateLimit/order";
    private final String DRIBBLET = "/sapi/v1/margin/dribblet";
    private final String AVAILABLE_INVENTORY = "/sapi/v1/margin/available-inventory";
    private final String CAPITAL_FLOW = "/sapi/v1/margin/capital-flow";
    private final String BNB_CONVERTABLE_ASSETS = "/sapi/v1/margin/dust";
    private final String DUST_TRANSFER = "/sapi/v1/margin/dust";
    private final String DELIST_SCHEDULE = "/sapi/v1/margin/delist-schedule";
    private final String NEXT_HOURLY_INTEREST_RATE = "/sapi/v1/margin/next-hourly-interest-rate";
    private final String SMALL_LIABILITY_ASSETS = "/sapi/v1/margin/exchange-small-liability";
    private final String EXCHANGE_SMALL_LIABILITY = "/sapi/v1/margin/exchange-small-liability";
    private final String SMALL_LIABILITY_EXCHANGE_HISTORY = "/sapi/v1/margin/exchange-small-liability-history";
    private final String LEVERAGE_BRACKET = "/sapi/v1/margin/leverageBracket";
    private final String TRADE_COEFF = "/sapi/v1/margin/tradeCoeff";

    public Margin(String baseUrl, String apiKey, String secretKey, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, new HmacSignatureGenerator(secretKey), proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public Margin(String baseUrl, String apiKey, SignatureGenerator signatureGenerator, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, signatureGenerator, proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public String crossMarginTransfer(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "asset", String.class);
        ParameterChecker.checkRequiredParameter(parameters, "amount");
        ParameterChecker.checkParameter(parameters, "type", Integer.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/transfer", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String borrow(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "asset", String.class);
        ParameterChecker.checkRequiredParameter(parameters, "amount");
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/loan", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String repay(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "asset", String.class);
        ParameterChecker.checkRequiredParameter(parameters, "amount");
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/repay", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String asset(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "asset", String.class);
        return this.requestHandler.sendApiRequest(this.baseUrl, "/sapi/v1/margin/asset", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String pair(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendApiRequest(this.baseUrl, "/sapi/v1/margin/pair", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String allAssets() {
        return this.requestHandler.sendApiRequest(this.baseUrl, "/sapi/v1/margin/allAssets", null, HttpMethod.GET, this.showLimitUsage);
    }

    public String allPairs() {
        return this.requestHandler.sendApiRequest(this.baseUrl, "/sapi/v1/margin/allPairs", null, HttpMethod.GET, this.showLimitUsage);
    }

    public String priceIndex(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendApiRequest(this.baseUrl, "/sapi/v1/margin/priceIndex", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String newOrder(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        ParameterChecker.checkParameter(parameters, "side", String.class);
        ParameterChecker.checkParameter(parameters, "type", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/order", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String cancelOrder(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/order", parameters, HttpMethod.DELETE, this.showLimitUsage);
    }

    public String cancelOpenOrders(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/openOrders", parameters, HttpMethod.DELETE, this.showLimitUsage);
    }

    public String transferHistory(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/transfer", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String loanRecord(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "asset", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/loan", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String repayRecord(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "asset", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/repay", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String interestHistory(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/interestHistory", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String forceLiquidationRec(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/forceLiquidationRec", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String account(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/account", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String getOrder(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/order", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String getOpenOrders(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/openOrders", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String getAllOrders(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/allOrders", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String ocoOrder(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        ParameterChecker.checkParameter(parameters, "side", String.class);
        ParameterChecker.checkRequiredParameter(parameters, "quantity");
        ParameterChecker.checkRequiredParameter(parameters, "price");
        ParameterChecker.checkRequiredParameter(parameters, "stopPrice");
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/order/oco", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String cancelOcoOrder(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/orderList", parameters, HttpMethod.DELETE, this.showLimitUsage);
    }

    public String getOcoOrder(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/orderList", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String getAllOcoOrders(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/allOrderList", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String getOcoOpenOrders(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/openOrderList", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String trades(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/myTrades", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String maxBorrow(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "asset", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/maxBorrowable", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String maxTransferable(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "asset", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/maxTransferable", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String isolatedTransfer(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "asset", String.class);
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        ParameterChecker.checkParameter(parameters, "transFrom", String.class);
        ParameterChecker.checkParameter(parameters, "transTo", String.class);
        ParameterChecker.checkRequiredParameter(parameters, "amount");
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/isolated/transfer", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String getIsolatedTransfer(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/isolated/transfer", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String isolatedAccount(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/isolated/account", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String disableIsolatedAccount(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/isolated/account", parameters, HttpMethod.DELETE, this.showLimitUsage);
    }

    public String enableIsolatedAccount(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/isolated/account", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String getIsolatedAccountLimit(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/isolated/accountLimit", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String getIsolatedSymbol(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/isolated/pair", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String getAllIsolatedSymbols(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/isolated/allPairs", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String bnbBurn(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/bnbBurn", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String getBnbBurn(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/bnbBurn", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String interestRateHistory(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "asset", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/interestRateHistory", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String crossMarginData(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/crossMarginData", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String crossMarginCollateralRatio() {
        return this.requestHandler.sendApiRequest(this.baseUrl, "/sapi/v1/margin/crossMarginCollateralRatio", null, HttpMethod.GET, this.showLimitUsage);
    }

    public String adjustCrossMarginMaxLeverage(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "maxLeverage", Integer.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/max-leverage", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String isolatedMarginData(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/isolatedMarginData", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String isolatedMarginTier(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/isolatedMarginTier", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String orderRateLimit(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/rateLimit/order", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String dribblet(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/dribblet", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String availableInventory(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "type", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/available-inventory", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String capitalFlow(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/capital-flow", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String bnbConvertibleAssets(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/dust", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String convertToBnB(Map<String, Object> parameters) {
        ParameterChecker.checkRequiredParameter(parameters, "asset");
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/dust", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String delistSchedule(Map<String, Object> parameters) {
        return this.requestHandler.sendApiRequest(this.baseUrl, "/sapi/v1/margin/delist-schedule", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String nextHourlyInterestRate(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "assets", String.class);
        ParameterChecker.checkParameter(parameters, "isIsolated", Boolean.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/next-hourly-interest-rate", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String smallLiabilityAssets(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/exchange-small-liability", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String exchangeSmallLiability(Map<String, Object> parameters) {
        ParameterChecker.checkRequiredParameter(parameters, "assetNames");
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/exchange-small-liability", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String smallLiabilityExchangeHistory(Map<String, Object> parameters) {
        ParameterChecker.checkRequiredParameter(parameters, "current");
        ParameterChecker.checkRequiredParameter(parameters, "size");
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/margin/exchange-small-liability-history", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String leverageBracket() {
        return this.requestHandler.sendApiRequest(this.baseUrl, "/sapi/v1/margin/leverageBracket", null, HttpMethod.GET, this.showLimitUsage);
    }

    public String tradeCoeff(Map<String, Object> parameters) {
        return this.requestHandler.sendApiRequest(this.baseUrl, "/sapi/v1/margin/tradeCoeff", parameters, HttpMethod.GET, this.showLimitUsage);
    }
}

