/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.impl.spot;

import com.binance.connector.client.enums.HttpMethod;
import com.binance.connector.client.utils.ParameterChecker;
import com.binance.connector.client.utils.ProxyAuth;
import com.binance.connector.client.utils.RequestHandler;
import com.binance.connector.client.utils.signaturegenerator.HmacSignatureGenerator;
import com.binance.connector.client.utils.signaturegenerator.SignatureGenerator;
import java.util.Map;

public class Convert {
    private final String baseUrl;
    private final RequestHandler requestHandler;
    private final boolean showLimitUsage;
    private final String TRADE_FLOW = "/sapi/v1/convert/tradeFlow";
    private final String EXCHANGE_INFO = "/sapi/v1/convert/exchangeInfo";
    private final String ASSET_QUANTITY_PRECISION = "/sapi/v1/convert/assetInfo";
    private final String QUOTE_INQUIRY = "/sapi/v1/convert/getQuote";
    private final String ACCEPT_QUOTE = "/sapi/v1/convert/acceptQuote";
    private final String ORDER_STATUS = "/sapi/v1/convert/orderStatus";

    public Convert(String baseUrl, String apiKey, String secretKey, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, new HmacSignatureGenerator(secretKey), proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public Convert(String baseUrl, String apiKey, SignatureGenerator signatureGenerator, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, signatureGenerator, proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public String tradeFlow(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "startTime", Long.class);
        ParameterChecker.checkParameter(parameters, "endTime", Long.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/convert/tradeFlow", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String exchangeInfo(Map<String, Object> parameters) {
        return this.requestHandler.sendPublicRequest(this.baseUrl, "/sapi/v1/convert/exchangeInfo", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String assetQuantityPrecision(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/convert/assetInfo", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String quoteInquiry(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "fromAsset", String.class);
        ParameterChecker.checkParameter(parameters, "toAsset", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/convert/getQuote", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String acceptQuote(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "quoteId", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/convert/acceptQuote", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String orderStatus(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/convert/orderStatus", parameters, HttpMethod.GET, this.showLimitUsage);
    }
}

