/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.impl.spot;

import com.binance.connector.client.enums.HttpMethod;
import com.binance.connector.client.utils.ParameterChecker;
import com.binance.connector.client.utils.ProxyAuth;
import com.binance.connector.client.utils.RequestHandler;
import com.binance.connector.client.utils.signaturegenerator.HmacSignatureGenerator;
import com.binance.connector.client.utils.signaturegenerator.SignatureGenerator;
import java.util.Map;

public class BSwap {
    private final String baseUrl;
    private final RequestHandler requestHandler;
    private final boolean showLimitUsage;
    private final String SWAP_POOLS = "/sapi/v1/bswap/pools";
    private final String LIQUIDITY = "/sapi/v1/bswap/liquidity";
    private final String LIQUIDITY_ADD = "/sapi/v1/bswap/liquidityAdd";
    private final String LIQUIDITY_REMOVE = "/sapi/v1/bswap/liquidityRemove";
    private final String LIQUIDITY_OPS = "/sapi/v1/bswap/liquidityOps";
    private final String QUOTE = "/sapi/v1/bswap/quote";
    private final String SWAP = "/sapi/v1/bswap/swap";
    private final String POOL_CONFIGURE = "/sapi/v1/bswap/poolConfigure";
    private final String ADD_LIQUIDITY_PREVIEW = "/sapi/v1/bswap/addLiquidityPreview";
    private final String REMOVE_LIQUIDITY_PREVIEW = "/sapi/v1/bswap/removeLiquidityPreview";
    private final String UNCLAIMED_REWARDS = "/sapi/v1/bswap/unclaimedRewards";
    private final String CLAIM_REWARDS = "/sapi/v1/bswap/claimRewards";
    private final String CLAIM_HISTORY = "/sapi/v1/bswap/claimedHistory";

    public BSwap(String baseUrl, String apiKey, String secretKey, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, new HmacSignatureGenerator(secretKey), proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public BSwap(String baseUrl, String apiKey, SignatureGenerator signatureGenerator, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, signatureGenerator, proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public String swapPools() {
        return this.requestHandler.sendApiRequest(this.baseUrl, "/sapi/v1/bswap/pools", null, HttpMethod.GET, this.showLimitUsage);
    }

    public String liquidity(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/bswap/liquidity", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String liquidityAdd(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "poolId", Long.class);
        ParameterChecker.checkParameter(parameters, "asset", String.class);
        ParameterChecker.checkRequiredParameter(parameters, "quantity");
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/bswap/liquidityAdd", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String liquidityRemove(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "poolId", Long.class);
        ParameterChecker.checkParameter(parameters, "type", String.class);
        ParameterChecker.checkRequiredParameter(parameters, "shareAmount");
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/bswap/liquidityRemove", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String liquidityOps(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/bswap/liquidityOps", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String quote(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "quoteAsset", String.class);
        ParameterChecker.checkParameter(parameters, "baseAsset", String.class);
        ParameterChecker.checkRequiredParameter(parameters, "quoteQty");
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/bswap/quote", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String swap(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "quoteAsset", String.class);
        ParameterChecker.checkParameter(parameters, "baseAsset", String.class);
        ParameterChecker.checkRequiredParameter(parameters, "quoteQty");
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/bswap/swap", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String swapHistory(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/bswap/swap", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String poolConfigure(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/bswap/poolConfigure", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String addLiquidityPreview(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "poolId", Long.class);
        ParameterChecker.checkParameter(parameters, "type", String.class);
        ParameterChecker.checkParameter(parameters, "quoteAsset", String.class);
        ParameterChecker.checkRequiredParameter(parameters, "quoteQty");
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/bswap/addLiquidityPreview", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String removeLiquidityPreview(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "poolId", Long.class);
        ParameterChecker.checkParameter(parameters, "type", String.class);
        ParameterChecker.checkParameter(parameters, "quoteAsset", String.class);
        ParameterChecker.checkRequiredParameter(parameters, "shareAmount");
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/bswap/removeLiquidityPreview", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String unclaimedRewards(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/bswap/unclaimedRewards", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String claimRewards(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/bswap/claimRewards", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String claimedHistory(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/bswap/claimedHistory", parameters, HttpMethod.GET, this.showLimitUsage);
    }
}

