/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.impl;

import com.binance.connector.client.enums.Category;
import com.binance.connector.client.exceptions.BinanceConnectorException;
import com.binance.connector.client.impl.websocketapi.WebSocketApiAccount;
import com.binance.connector.client.impl.websocketapi.WebSocketApiAuth;
import com.binance.connector.client.impl.websocketapi.WebSocketApiGeneral;
import com.binance.connector.client.impl.websocketapi.WebSocketApiMarket;
import com.binance.connector.client.impl.websocketapi.WebSocketApiModule;
import com.binance.connector.client.impl.websocketapi.WebSocketApiTrade;
import com.binance.connector.client.impl.websocketapi.WebSocketApiUserDataStream;
import com.binance.connector.client.utils.websocketapi.WebSocketApiRequestHandler;

public final class WebSocketApiModuleFactory {
    private static WebSocketApiAccount wsApiAccount;
    private static WebSocketApiAuth wsApiAuth;
    private static WebSocketApiGeneral wsApiGeneral;
    private static WebSocketApiMarket wsApiMarket;
    private static WebSocketApiTrade wsApiTrade;
    private static WebSocketApiUserDataStream wsApiUserDataStream;

    private WebSocketApiModuleFactory() {
    }

    private static WebSocketApiModule obtainModule(WebSocketApiModule module, ModuleCreator creator) {
        if (module == null) {
            module = creator.create();
        }
        return module;
    }

    public static WebSocketApiModule build(Category category, WebSocketApiRequestHandler requestHandler) {
        switch (category) {
            case ACCOUNT: {
                return WebSocketApiModuleFactory.obtainModule(wsApiAccount, () -> new WebSocketApiAccount(requestHandler));
            }
            case AUTH: {
                return WebSocketApiModuleFactory.obtainModule(wsApiAuth, () -> new WebSocketApiAuth(requestHandler));
            }
            case GENERAL: {
                return WebSocketApiModuleFactory.obtainModule(wsApiGeneral, () -> new WebSocketApiGeneral(requestHandler));
            }
            case MARKET: {
                return WebSocketApiModuleFactory.obtainModule(wsApiMarket, () -> new WebSocketApiMarket(requestHandler));
            }
            case TRADE: {
                return WebSocketApiModuleFactory.obtainModule(wsApiTrade, () -> new WebSocketApiTrade(requestHandler));
            }
            case USER_DATA_STREAM: {
                return WebSocketApiModuleFactory.obtainModule(wsApiUserDataStream, () -> new WebSocketApiUserDataStream(requestHandler));
            }
        }
        throw new BinanceConnectorException("Unknown WebSocket API Category: " + (Object)((Object)category));
    }

    private static interface ModuleCreator {
        public WebSocketApiModule create();
    }
}

