/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.common.sign;

import com.binance.connector.client.common.ApiException;
import com.binance.connector.client.common.sign.SignatureGenerator;
import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.signers.Ed25519Signer;
import org.bouncycastle.crypto.signers.RSADigestSigner;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.internal.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;

public class PrivateKey
implements SignatureGenerator {
    protected Signer signer;

    public void init(byte[] keyContent) {
        String privateKey = this.removeHeaderFooter(new String(keyContent));
        byte[] decode = Base64.getDecoder().decode(privateKey);
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(decode);
        PrivateKeyInfo instance = PrivateKeyInfo.getInstance((Object)pkcs8EncodedKeySpec.getEncoded());
        ASN1ObjectIdentifier algorithmIdentifier = instance.getPrivateKeyAlgorithm().getAlgorithm();
        AsymmetricKeyParameter key = null;
        try {
            key = PrivateKeyFactory.createKey((PrivateKeyInfo)instance);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.signer = this.getSigner(algorithmIdentifier, key);
    }

    public void init(byte[] keyContent, String password) throws ApiException {
        if (password == null) {
            this.init(keyContent);
            return;
        }
        String s = new String(keyContent);
        s = this.removeEncryptedHeaderFooter(s);
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            PKCS8EncryptedPrivateKeyInfo pkcs8EncryptedPrivateKeyInfo = new PKCS8EncryptedPrivateKeyInfo(Base64.getDecoder().decode(s.getBytes()));
            JcaPEMKeyConverter jcaPEMKeyConverter = new JcaPEMKeyConverter();
            InputDecryptorProvider inputDecryptorProvider = new JceOpenSSLPKCS8DecryptorProviderBuilder().build(password.toCharArray());
            PrivateKeyInfo privateKeyInfo = pkcs8EncryptedPrivateKeyInfo.decryptPrivateKeyInfo(inputDecryptorProvider);
            java.security.PrivateKey privateKey = jcaPEMKeyConverter.getPrivateKey(privateKeyInfo);
            PrivateKeyInfo instance = PrivateKeyInfo.getInstance((Object)privateKey.getEncoded());
            AsymmetricKeyParameter key = PrivateKeyFactory.createKey((PrivateKeyInfo)instance);
            ASN1ObjectIdentifier algorithmIdentifier = instance.getPrivateKeyAlgorithm().getAlgorithm();
            this.signer = this.getSigner(algorithmIdentifier, key);
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
    }

    @Override
    public byte[] sign(String input) throws CryptoException {
        return this.sign(input.getBytes());
    }

    @Override
    public byte[] sign(byte[] input) throws CryptoException {
        this.signer.update(input, 0, input.length);
        byte[] generateSignature = this.signer.generateSignature();
        return Base64.getEncoder().encode(generateSignature);
    }

    @Override
    public String signAsString(String input) throws CryptoException {
        return this.signAsString(input.getBytes());
    }

    @Override
    public String signAsString(byte[] input) throws CryptoException {
        return new String(this.sign(input));
    }

    protected String removeEncryptedHeaderFooter(String input) {
        return input.replace(System.lineSeparator(), "").replace("-----BEGIN ENCRYPTED PRIVATE KEY-----", "").replace("-----END ENCRYPTED PRIVATE KEY-----", "");
    }

    protected String removeHeaderFooter(String input) {
        return input.replace(System.lineSeparator(), "").replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "");
    }

    private Signer getSigner(ASN1ObjectIdentifier algorithmIdentifier, AsymmetricKeyParameter key) {
        if (EdECObjectIdentifiers.id_Ed25519.equals((ASN1Primitive)algorithmIdentifier)) {
            Ed25519Signer signer = new Ed25519Signer();
            signer.init(true, (CipherParameters)key);
            return signer;
        }
        if (PKCSObjectIdentifiers.rsaEncryption.equals((ASN1Primitive)algorithmIdentifier)) {
            RSADigestSigner signer = new RSADigestSigner((Digest)new SHA256Digest());
            signer.init(true, (CipherParameters)key);
            return signer;
        }
        return null;
    }
}

