/*
 * Decompiled with CFR 0.152.
 */
package io.github.biezhi.excel.plus.writer;

import io.github.biezhi.excel.plus.Writer;
import io.github.biezhi.excel.plus.annotation.ExcelColumn;
import io.github.biezhi.excel.plus.exception.WriterException;
import io.github.biezhi.excel.plus.writer.ExcelWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class WriterWithCSV
extends ExcelWriter {
    private OutputStream outputStream;
    private List<String[]> csvLines;

    public WriterWithCSV(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public void writeSheet(Writer writer) throws WriterException {
        Collection<?> rows = writer.rows();
        this.parseCSVLines(rows);
        try (OutputStreamWriter osWriter = new OutputStreamWriter(this.outputStream, writer.charset());){
            osWriter.write(65279);
            for (String[] csvLine : this.csvLines) {
                this.writeLine(osWriter, csvLine);
            }
        }
        catch (Exception e) {
            throw new WriterException(e);
        }
    }

    private void writeLine(OutputStreamWriter osWriter, String[] csvLine) throws IOException {
        for (int i = 0; i < csvLine.length; ++i) {
            String col = csvLine[i];
            col = null == col ? "" : col;
            osWriter.write(col);
            if (i >= csvLine.length - 1) continue;
            osWriter.write(",");
        }
        osWriter.write("\n");
    }

    private void parseCSVLines(Collection<?> rows) {
        this.csvLines = new ArrayList<String[]>(rows.size());
        Class<?> type = rows.iterator().next().getClass();
        Field[] fields = type.getDeclaredFields();
        HashMap<Integer, Field> fieldIndexes = new HashMap<Integer, Field>(fields.length);
        for (Field field : fields) {
            ExcelColumn column = field.getAnnotation(ExcelColumn.class);
            if (null == column) continue;
            field.setAccessible(true);
            fieldIndexes.put(column.index(), field);
        }
        List<Field> sortedFields = fieldIndexes.keySet().stream().sorted().map(fieldIndexes::get).collect(Collectors.toList());
        for (Object item : rows) {
            try {
                String[] row = this.parseRow(sortedFields, item);
                this.csvLines.add(row);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String[] parseRow(List<Field> sortedFields, Object item) throws Exception {
        String[] row = new String[sortedFields.size()];
        int size = sortedFields.size();
        for (int i = 0; i < size; ++i) {
            Object value = sortedFields.get(i).get(item);
            row[i] = null == value ? "" : this.computeColumnContent(value, sortedFields.get(i));
        }
        return row;
    }
}

