/*
 * Decompiled with CFR 0.152.
 */
package io.github.biezhi.excel.plus.writer;

import io.github.biezhi.excel.plus.exception.WriterException;
import io.github.biezhi.excel.plus.util.StringUtil;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletResponse;

public final class ResponseWrapper {
    public static OutputStream createXLSX(HttpServletResponse servletResponse, String fileName) throws WriterException {
        servletResponse.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        return ResponseWrapper.create(servletResponse, fileName);
    }

    public static OutputStream createXLS(HttpServletResponse servletResponse, String fileName) throws WriterException {
        servletResponse.setContentType("application/vnd.ms-excel");
        return ResponseWrapper.create(servletResponse, fileName);
    }

    public static OutputStream create(HttpServletResponse servletResponse, String fileName) throws WriterException {
        try {
            if (null == servletResponse) {
                throw new WriterException("response instance not null");
            }
            if (StringUtil.isEmpty(fileName)) {
                throw new WriterException("response file name not empty");
            }
            fileName = new String(fileName.getBytes(StandardCharsets.UTF_8), "ISO8859-1");
            servletResponse.setHeader("Content-Disposition", "attachment; filename=" + fileName);
            return servletResponse.getOutputStream();
        }
        catch (Exception e) {
            throw new WriterException(e);
        }
    }

    private ResponseWrapper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

