/*
 * Decompiled with CFR 0.152.
 */
package io.github.biezhi.excel.plus.util;

import io.github.biezhi.excel.plus.exception.ReaderException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public final class ExcelUtil {
    public static <T> T newInstance(Class<T> type) {
        try {
            return type.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Workbook create(File file) throws ReaderException {
        try {
            return WorkbookFactory.create((File)file);
        }
        catch (IOException e) {
            throw new ReaderException(e);
        }
    }

    public static Workbook create(InputStream inputStream) throws ReaderException {
        try {
            return WorkbookFactory.create((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new ReaderException(e);
        }
    }

    public static String getFileExtension(String fileName) {
        int lastIndexOf = fileName.lastIndexOf(".");
        if (lastIndexOf == -1) {
            return "";
        }
        return fileName.substring(lastIndexOf + 1);
    }

    public static boolean isXLSX(File file) {
        if (null == file || !file.exists()) {
            return false;
        }
        String ext = ExcelUtil.getFileExtension(file.getName());
        return ext.toUpperCase().equals("XLSX");
    }

    public static boolean isXLS(File file) {
        if (null == file || !file.exists()) {
            return false;
        }
        String ext = ExcelUtil.getFileExtension(file.getName());
        return ext.toUpperCase().equals("XLS");
    }

    public static boolean isCSV(File file) {
        if (null == file || !file.exists()) {
            return false;
        }
        String ext = ExcelUtil.getFileExtension(file.getName());
        return ext.toUpperCase().equals("CSV");
    }

    public static byte[] streamAsBytes(InputStream inputStream) throws IOException {
        int len;
        if (null == inputStream) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = inputStream.read(buffer)) > -1) {
            baos.write(buffer, 0, len);
        }
        baos.flush();
        return baos.toByteArray();
    }

    public static boolean isXLSX(InputStream inputStream) {
        try {
            new XSSFWorkbook(inputStream);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isXLS(InputStream inputStream) {
        try {
            new HSSFWorkbook(inputStream);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private ExcelUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

