/*
 * Decompiled with CFR 0.152.
 */
package io.github.biezhi.excel.plus.reader;

import io.github.biezhi.excel.plus.conveter.Converter;
import io.github.biezhi.excel.plus.reader.ReaderConverter;
import io.github.biezhi.excel.plus.util.ExcelUtil;
import java.lang.reflect.Field;
import java.util.stream.Stream;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.eventusermodel.XSSFSheetXMLHandler;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SheetToCSV<T>
extends ReaderConverter
implements XSSFSheetXMLHandler.SheetContentsHandler {
    private static final Logger log = LoggerFactory.getLogger(SheetToCSV.class);
    private boolean firstCellOfRow;
    private int currentRow = -1;
    private int currentCol = -1;
    private final OPCPackage opcPackage;
    private final Stream.Builder<T> rowsStream;
    private final Class<T> type;
    private final int startRow;
    private T row;

    public SheetToCSV(OPCPackage opcPackage, int startRow, Class<T> type) {
        this.opcPackage = opcPackage;
        this.rowsStream = Stream.builder();
        this.startRow = startRow;
        this.type = type;
        try {
            this.initFieldConverter(type.getDeclaredFields());
        }
        catch (Exception e) {
            log.error("init field converter fail", (Throwable)e);
        }
    }

    public void startRow(int rowNum) {
        this.firstCellOfRow = true;
        this.currentRow = rowNum;
        this.currentCol = -1;
        if (this.currentRow < this.startRow) {
            return;
        }
        this.row = ExcelUtil.newInstance(this.type);
    }

    public void endRow(int rowNum) {
        if (this.currentRow < this.startRow) {
            return;
        }
        this.rowsStream.add(this.row);
    }

    public void cell(String cellReference, String formattedValue, XSSFComment comment) {
        if (this.currentRow < this.startRow) {
            return;
        }
        if (this.firstCellOfRow) {
            this.firstCellOfRow = false;
        }
        if (cellReference == null) {
            cellReference = new CellAddress(this.currentRow, this.currentCol).formatAsString();
        }
        this.currentCol = new CellReference(cellReference).getCol();
        Field field = (Field)this.fieldIndexes.get(this.currentCol);
        if (null != field) {
            try {
                String cellValue = formattedValue;
                Converter converter = (Converter)this.fieldConverters.get(field);
                if (null != converter) {
                    cellValue = converter.stringToR(formattedValue);
                }
                field.set(this.row, cellValue);
            }
            catch (Exception e) {
                log.error("write field {} value fail", (Object)field.getName(), (Object)e);
            }
        }
    }

    public OPCPackage getOpcPackage() {
        return this.opcPackage;
    }

    public Stream.Builder<T> getRowsStream() {
        return this.rowsStream;
    }
}

