/*
 * Decompiled with CFR 0.152.
 */
package io.github.biezhi.excel.plus.reader;

import io.github.biezhi.excel.plus.Reader;
import io.github.biezhi.excel.plus.exception.ReaderException;
import io.github.biezhi.excel.plus.reader.ExcelReader;
import io.github.biezhi.excel.plus.reader.SheetToCSV;
import io.github.biezhi.excel.plus.reader.XLSXDataFormatter;
import io.github.biezhi.excel.plus.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.stream.Stream;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.poi.ooxml.util.SAXHelper;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.eventusermodel.ReadOnlySharedStringsTable;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.eventusermodel.XSSFSheetXMLHandler;
import org.apache.poi.xssf.model.SharedStrings;
import org.apache.poi.xssf.model.Styles;
import org.apache.poi.xssf.model.StylesTable;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ReaderWith2007
implements ExcelReader {
    public ReaderWith2007(Workbook workbook) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> Stream<T> readExcel(Reader reader) throws ReaderException {
        Class type = reader.modelType();
        try (OPCPackage p = this.getPackage(reader);){
            SheetToCSV sheetToCSV = new SheetToCSV(p, reader.startRow(), type);
            this.process(reader, sheetToCSV);
            Stream.Builder stream = sheetToCSV.getRowsStream();
            Stream stream2 = stream.build();
            return stream2;
        }
        catch (Exception e) {
            throw new ReaderException(e);
        }
    }

    private OPCPackage getPackage(Reader reader) throws Exception {
        if (reader.fromFile() != null) {
            return OPCPackage.open((File)reader.fromFile(), (PackageAccess)PackageAccess.READ);
        }
        return OPCPackage.open((InputStream)reader.fromStream());
    }

    public void process(Reader reader, SheetToCSV sheetToCSV) throws IOException, OpenXML4JException, SAXException {
        ReadOnlySharedStringsTable strings = new ReadOnlySharedStringsTable(sheetToCSV.getOpcPackage());
        XSSFReader xssfReader = new XSSFReader(sheetToCSV.getOpcPackage());
        StylesTable styles = xssfReader.getStylesTable();
        XSSFReader.SheetIterator iter = (XSSFReader.SheetIterator)xssfReader.getSheetsData();
        int index = 0;
        boolean bySheetName = StringUtil.isNotEmpty(reader.sheetName());
        while (iter.hasNext()) {
            try (InputStream stream = iter.next();){
                String sheetName = iter.getSheetName();
                if (bySheetName && reader.sheetName().equals(sheetName)) {
                    this.processSheet((Styles)styles, (SharedStrings)strings, sheetToCSV, stream);
                    break;
                }
                if (!bySheetName && reader.sheetIndex() == index) {
                    this.processSheet((Styles)styles, (SharedStrings)strings, sheetToCSV, stream);
                    break;
                }
            }
            ++index;
        }
    }

    public void processSheet(Styles styles, SharedStrings strings, XSSFSheetXMLHandler.SheetContentsHandler sheetHandler, InputStream sheetInputStream) throws IOException, SAXException {
        XLSXDataFormatter formatter = new XLSXDataFormatter();
        InputSource sheetSource = new InputSource(sheetInputStream);
        try {
            XMLReader sheetParser = SAXHelper.newXMLReader();
            XSSFSheetXMLHandler handler = new XSSFSheetXMLHandler(styles, null, strings, sheetHandler, (DataFormatter)formatter, false);
            sheetParser.setContentHandler((ContentHandler)handler);
            sheetParser.parse(sheetSource);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("SAX parser appears to be broken - " + e.getMessage());
        }
    }
}

