/*
 * Decompiled with CFR 0.152.
 */
package io.github.biezhi.excel.plus.conveter;

import io.github.biezhi.excel.plus.conveter.Converter;
import io.github.biezhi.excel.plus.exception.ConverterException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class LocalDateTimeConverter
implements Converter<String, LocalDateTime> {
    private DateTimeFormatter formatter;

    public LocalDateTimeConverter(String pattern) {
        this.formatter = DateTimeFormatter.ofPattern(pattern);
    }

    @Override
    public LocalDateTime stringToR(String value) throws ConverterException {
        try {
            if (null == value) {
                return null;
            }
            return LocalDateTime.parse(value, this.formatter);
        }
        catch (Exception e) {
            throw new ConverterException("convert [" + value + "] to LocalDateTime error", e);
        }
    }

    @Override
    public String toString(LocalDateTime localDateTime) {
        if (null == localDateTime) {
            return null;
        }
        return localDateTime.format(this.formatter);
    }
}

