/*
 * Decompiled with CFR 0.152.
 */
package io.github.biezhi.excel.plus.conveter;

import io.github.biezhi.excel.plus.conveter.Converter;
import io.github.biezhi.excel.plus.exception.ConverterException;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public class LocalDateConverter
implements Converter<String, LocalDate> {
    private DateTimeFormatter formatter;

    public LocalDateConverter(String pattern) {
        this.formatter = DateTimeFormatter.ofPattern(pattern);
    }

    @Override
    public LocalDate stringToR(String value) throws ConverterException {
        try {
            if (null == value) {
                return null;
            }
            return LocalDate.parse(value, this.formatter);
        }
        catch (DateTimeParseException e) {
            try {
                YearMonth ym = YearMonth.parse(value, this.formatter);
                return ym.atDay(1);
            }
            catch (Exception e2) {
                throw new ConverterException("convert [" + value + "] to LocalDate error", e2);
            }
        }
        catch (Exception e) {
            throw new ConverterException("convert [" + value + "] to LocalDate error", e);
        }
    }

    @Override
    public String toString(LocalDate localDate) {
        if (null == localDate) {
            return null;
        }
        return localDate.format(this.formatter);
    }
}

